import time
import requests
from edge_engine.common.logsetup import logger


class RelayHandler:

    @staticmethod
    def update_relay_status(
            ep: str,
            payload: dict,
    ) -> None:
        logger.debug("Updating the relay status to : {}".format(payload))
        response = None
        for _ in range(0, 3):
            response = requests.post(url=ep, json=payload, timeout=10)
            if response.status_code == 200 and response.json().get('status'):
                return
            time.sleep(1)

        logger.error("Unable to update the relay status. Error: {}".format(response.content))
        raise RuntimeError("Unable to communicate to belt relay!")