from datetime import datetime

from scripts.common.config import MONGO_DB_OBJ


class ModelCountTracker:
    def __init__(
            self,
            device_id,
    ) -> None:
        self.device_id = device_id
        self.count_tracker = None
        self._reset_tracker()

    def _reset_tracker(self):
        self.count_tracker = list()

    def __call__(
            self,
            conf: float,
    ) -> None:
        self.count_tracker.append(
            {
                "time": datetime.now(),
                "deviceId": self.device_id,
                "count_confidence": conf
            })
        if len(self.count_tracker) >= 10:
            self.insert_to_mongo(self.count_tracker)
            self._reset_tracker()

    @staticmethod
    def insert_to_mongo(
            payload: list,
            collection_name: str = "model_count_tracker"
    ) -> None:
        MONGO_DB_OBJ[collection_name].insert_many(payload)


class ModelTracker:
    def __init__(
            self,
            device_id,
    ) -> None:
        self.device_id = device_id
        self.model_tracker = None
        self._reset_tracker()

    def _reset_tracker(self):
        self.model_tracker = list()

    def __call__(
            self,
            conf: float,
    ) -> None:
        self.model_tracker.append(
            {
                "time": datetime.now(),
                "deviceId": self.device_id,
                "model_confidence": conf
            })
        if len(self.model_tracker) >= 500:
            self.insert_to_mongo(self.model_tracker)
            self._reset_tracker()

    @staticmethod
    def insert_to_mongo(
            payload: list,
            collection_name: str = "model_confidence_tracker"
    ) -> None:
        MONGO_DB_OBJ[collection_name].insert_many(payload)
