import os
os.environ["config"]="{\"DEPLOYMENT_ID\": \"pptestcam2_d7a0b6ec\", \"GET_JANUS_DETAILS\":\"http://192.168.3.181/camera_api/custom/get_janus?deploymentId=\", \"MONGO_URI\":\"http://192.168.3.181/camera_api/events/add_event\"}"



from edge_engine.edge_processor import ExecutePipeline
from edge_engine.edge_processor import Pubs
from edge_engine.model_optimizer import ModelOptimization
from scripts import CementBagCounter
from edge_engine.common.config import EDGE_CONFIG

if __name__ == '__main__':
    model_optimization = ModelOptimization(num_class=1, weight_path="/app/data/best.wts", image_size=416)
    model_optimization.change_configurations()
    model_optimization.optimize_model()
    pubs = Pubs()
    mod = CementBagCounter(config=EDGE_CONFIG,
                           model_config=EDGE_CONFIG["modelConfig"],
                           pubs=pubs,
                           device_id=EDGE_CONFIG['deviceId'])
    ex = ExecutePipeline(mod)
    ex.run_model()
