from datetime import datetime
from pymongo import MongoClient
import docker
import json
import time
from loguru import logger


docker_client = docker.DockerClient(base_url='unix://var/run/docker.sock')
URI = "mongodb://admin:iLens%241234@192.168.3.181:2717/admin?connectTimeoutMS=10000&authSource=admin&authMechanism=SCRAM-SHA-1&3t.uriVersion=3&3t.databases=admin&3t.alwaysShowAuthDB=true&3t.alwaysShowDBFromUserRole=true"
database_name = "ilens_ai"
collection_name = "eventLogs"
try:

    client = MongoClient(URI)
    database = client[database_name]
    collection = database[collection_name]
    logger.info(f"Connected to mongo database {database}")
    my_query = {"cameraName":"jk_camera2"}

    event = collection.find(my_query).sort("_id", -1)[0]
    current_time = datetime.now()
    event_time = event['timestamp']
    print(event_time)
    time_diff_in_sec = (current_time - event_time).total_seconds()
    # Opening JSON file
    f = open('data.json')

    # returns JSON object as a dictionary
    data = json.load(f)
    # Closing file
    f.close()
    last_record_time = data['last_record_time']
    last_docker_restart_time = data['docker_restart_time']

    docker_restart_time_diff = time.time() - last_docker_restart_time

    if(time_diff_in_sec > 60):
        if(last_record_time == event_time):
            if(docker_restart_time_diff > 3600):
                logger.info("Container is frozen for more than one hour, restart required")
                docker_client.containers.get("77ccc73eb613").restart()


        else:
            logger.info("Container is frozen, restart required")
            docker_client.containers.get("77ccc73eb613").restart()
except Exception as e:
    logger.info(f"Failed to connect to Mongo : {e}")

