import cv2
import time
import datetime
import os

class DataCollector():
    def __init__(self, stream, project, loader, camera, duration):
        self.stream = stream
        self.project = project
        self.loader = loader
        self.camera = camera
        self.duration = duration
        self.status = "raw"

    def data_collector(self):
        cap = cv2.VideoCapture(self.stream)
        ret, img = cap.read()
        start_time = time.time()
        frame_count = 0
        while ret:
            img = cv2.resize(img, (416, 416))

            current_date_time = datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
            current_date_time = current_date_time.replace("-", "")
            current_date_time = current_date_time.replace(" ", "")
            current_date_time = current_date_time.replace(":", "")
            dest_name = self.project +"_"+ self.loader +"_"+ self.camera +"_"+ current_date_time +"_"+ str(frame_count) +"_"+ self.status + ".jpg"
            current_dir = os.getcwd()
            temp_path = os.path.join(current_dir, "temp")
            if not (os.path.exists(temp_path)):
                os.mkdir(temp_path)
            dest_path = os.path.join(temp_path, dest_name)
            cv2.imwrite(dest_path, img)
            frame_count += 1
            ret, img = cap.read()
            end_time = time.time()
            if((end_time - start_time) > float(self.duration)):
                ret = False
                frame_count = 0

s = DataCollector(stream="rtsp://user:myPass@123@192.168.0.51:554/Streaming/Channels/102", project="jk", loader="1", camera="1", duration=1)
s.data_collector()
