
# importing OpenCV
import cv2


class SanityCheck():
    """Class to check presence of cement bag using motion detection"""
    def __init__(self, frame_batch):
        self.data_batch = frame_batch
        # Assigning our static_back to None
        self.static_back = None

        # List when any moving object appear
        self.motion_list = [None, None]

        # Time of movement
        self.time = []
        self.sanity_check_status = False


    def sanity_check(self):
        for frame in self.data_batch:
            # Reading frame(image) from video
            # check, frame = video.read()

            # Initializing motion = 0(no motion)
            motion = 0

            # Converting color image to gray_scale image
            gray = cv2.cvtColor(frame, cv2.COLOR_BGR2GRAY)

            # Converting gray scale image to GaussianBlur
            # so that change can be find easily
            gray = cv2.GaussianBlur(gray, (21, 21), 0)

            # In first iteration we assign the value
            # of static_back to our first frame
            if self.static_back is None:
                self.static_back = gray
                continue

            # Difference between static background
            # and current frame(which is GaussianBlur)
            diff_frame = cv2.absdiff(self.static_back, gray)

            # If change in between static background and
            # current frame is greater than 30 it will show white color(255)
            thresh_frame = cv2.threshold(diff_frame, 30, 255, cv2.THRESH_BINARY)[1]
            thresh_frame = cv2.dilate(thresh_frame, None, iterations=2)

            # Finding contour of moving object
            cnts, _ = cv2.findContours(thresh_frame.copy(),
                                       cv2.RETR_EXTERNAL, cv2.CHAIN_APPROX_SIMPLE)

            for contour in cnts:
                if cv2.contourArea(contour) < 10000:
                    self.sanity_check_status = False
                    continue
                self.sanity_check_status = True

            self.static_back = gray
        return  self.sanity_check_status


arr = []
# Capturing video
video = cv2.VideoCapture(r"C:\Users\sikhin.vc\Downloads\GOLD\OLD_MRP_CAMERA\2021-12-25_11-10-00.mp4")
count = 0
# Infinite while loop to treat stack of image as video
while True:
	# Reading frame(image) from video
    check, frame = video.read()
    print(type(frame))
    arr.append(frame)
    count+= 1
    if(count == 10):
        break

s = SanityCheck(frame_batch=arr)
status = s.sanity_check()

print(status)