from edge_engine.common.logsetup import logger
from edge_engine.common.config import DEVICE_ID
from uuid import uuid4
import traceback
class FrameProcessor:
    def __init__(self, stream, model):
        self.model = model
        self.stream = stream
        self.old_video_capture_count = 0
        logger.info("Setting up frame processor !!")
        self.count = 0
        self.skip_frame_every = 30  # 1 does not skip any frame (n-1 frames get skipped)


    def run_model(self):
        count = 0
        while self.stream.running():
            try:

                # video_capture_count = self.stream.get_frame_count()
                # if(video_capture_count != self.old_video_capture_count):
                #
                #     self.old_video_capture_count = video_capture_count
                #     count = 0
                # if(video_capture_count == 1):
                #     count = 0

                count += 1
                logger.debug("Getting frame mask_model")
                frame, count_1 = self.stream.read()

                if frame is not None and self.count % self.skip_frame_every == 0:
                    fid = uuid4()
                    data = {
                        "frame": frame,
                        "frameId": self.count,
                        "deviceId": "{}".format(DEVICE_ID),
                    }

                    self.model.predict(data)
                self.count += 1
                # logger.debug("Running mask_model")
                # data = {"frame": frame, "frameId": "{}".format(uuid4()), "deviceId": "{}".format(DEVICE_ID), "frame_id": count}
                # self.model.predict(data)
                # logger.debug("publishing mask_model output")
                if(self.count == 3227):
                    self.count = 0
            except Exception as e:
                logger.error(e)
                logger.error(traceback.format_exc())