from edge_engine.common.logsetup import logger
import cv2


def draw_circles_on_frame(frame, point, radius=3, color=(255, 255, 255), thickness=1):
    """
    draw circle on the objects
    :param radius: radius of the circle
    :param frame: frame to draw on
    :param point: co-ordinate to draw on
    :param color: color of the circle
    :param thickness: thickness of the circle
    :return: frame
    """
    logger.debug("Drawing circle centroid on the frame")
    return cv2.circle(frame, tuple(point), radius, color, thickness)


def resize_to_64_64(frame):
    """
    resize the from
    :param frame: frame
    :return: frame
    """
    logger.debug("Resizing the frame to 64 x 64")
    return cv2.resize(frame, (64, 64))