import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { DataTablesModule } from 'angular-datatables';
import { FormsModule } from '@angular/forms';
import { OwlDateTimeModule, OwlNativeDateTimeModule, OWL_DATE_TIME_FORMATS } from 'ng-pick-datetime';

import { TableServerSideComponent } from './table-server-side.component';
import { TableServerSide } from './service/table-server-side';
import { NgSelectModule } from '@ng-select/ng-select';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
// import { SimpleDfmModule } from '../simple-dfm/simple-dfm.module';

export const MY_CUSTOM_FORMATS = {
  fullPickerInput: 'YYYY-MM-DD HH:mm:ss',
  parseInput: 'YYYY-MM-DD HH:mm:ss',
  datePickerInput: 'YYYY-MM-DD HH:mm:ss',
  timePickerInput: 'LT',
  monthYearLabel: 'MMM YYYY',
  dateA11yLabel: 'LL',
  monthYearA11yLabel: 'MMMM YYYY'
};

@NgModule({
  declarations: [
    TableServerSideComponent
  ],
  imports: [
    CommonModule,
    DataTablesModule,
    FormsModule,
    NgSelectModule,
    OwlDateTimeModule,
    OwlNativeDateTimeModule,
    NgbModule
    // SimpleDfmModule
  ],
  exports: [
    TableServerSideComponent
  ],
  providers: [
    TableServerSide,
    {
      provide: OWL_DATE_TIME_FORMATS,
      useValue: MY_CUSTOM_FORMATS
    }
  ]
})
export class TableServerSideModule { }
