import { NgModule } from '@angular/core';
import { BrowserModule } from '@angular/platform-browser';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';

import { AppRoutingModule } from './app-routing.module';
import { AppComponent } from './app.component';
import { NgxAnnotateTextModule } from "ngx-annotate-text";
import { CommonComponentsModule } from './common-components/common-components.module';
import { ToasterModule, ToasterService } from 'angular2-toaster';
import { HttpClientModule, HTTP_INTERCEPTORS } from '@angular/common/http';
import { HttpLayerService } from './services/http-layer.service';
import { HashLocationStrategy, LocationStrategy } from '@angular/common';
import { HttpRequestInterceptor } from './services/http-interceptors';

@NgModule({
  declarations: [
    AppComponent,
  ],
  imports: [
    BrowserModule,
    AppRoutingModule,
    CommonComponentsModule,
    NgxAnnotateTextModule,
    ToasterModule,
    HttpClientModule,   
     BrowserModule,
    BrowserAnimationsModule,
  ],
  providers: [
    { provide: HTTP_INTERCEPTORS, useClass: HttpRequestInterceptor, multi: true },
    { provide: LocationStrategy, useClass: HashLocationStrategy },
    HttpLayerService, ToasterService,
  ],
  bootstrap: [AppComponent]
})
export class AppModule { }
