import { Injectable } from '@angular/core';

@Injectable({
  providedIn: 'root'
})
export class SessionService {

  constructor() { }

  // tslint:disable: function-name
  private _getLocal(key: string) {
    let data: any = localStorage.getItem(key);
    if (data) {
      return JSON.parse(data);
    }
    return data;
  }
  private _saveLocal(key: string, value: any) {
    return localStorage.setItem(key, JSON.stringify(value));
  }
  private _removeLocal(key: string) {
    return localStorage.removeItem(key);
  }
  private _clearLocal() {
    return localStorage.clear();
  }
  private _getSession(key: string) {
    let data: any;
    try {
      let data1: any = sessionStorage.getItem(key);
      data = JSON.parse(data1);
    } catch (e) {
      data = sessionStorage.getItem(key);
    }
    return data;
  }
  private _saveSession(key: string, value: any) {
    return sessionStorage.setItem(key, JSON.stringify(value));
  }
  private _removeSession(key: string) {
    return sessionStorage.removeItem(key);
  }
  private _clearSession() {
    return sessionStorage.clear();
  }
  // tslint:disable-next-line:member-ordering
  public api = {
    local: {
      get: this._getLocal,
      save: this._saveLocal,
      remove: this._removeLocal,
      clear: this._clearLocal
    },
    session: {
      get: this._getSession,
      save: this._saveSession,
      remove: this._removeSession,
      clear: this._clearSession
    }
  };
}

