import APP_CONSTANTS from '../../assets/jsons/app-constants.json';
const config = '';
// const config = 'config/';
// tslint:disable:whitespace

const domain = window.location.href.split('#')[0].split('://')[0];
const mainUrl = window.location.href;
const baseUrl = mainUrl.split('#');
const hostDomain = window.location.host;

export class Config {
  /**
   * Production Base Points
   */
  public static get BASE_POINT_API(): string { return APP_CONSTANTS.BASE_POINT_API_URL; }
  // public static get BASE_POINT_API(): string { return '' }
  // public static get GRAPH_QL_API(): string { return APP_CONSTANTS.GRAPH_QL_API; }
  public static get BASE_POINT_JSON(): string { return 'assets/jsons/'; }

  // tslint:disable: prefer-template
  public static API: any = {
    FILE_TABLE: Config.BASE_POINT_API + 'get_file_grid', // file grid 
    SUBMIT_ALL_RECORDS: Config.BASE_POINT_API + 'submit_file_grid', // Submit all table-datatypes in whole 
    REQUEST_TABLE: Config.BASE_POINT_API + 'get_table_data', // table-datatypes grid
    DELETE_ROW: Config.BASE_POINT_API + 'delete_file_details', // delete from table-datatypes grid
    ANNOTATIONS_DATA: Config.BASE_POINT_API + 'get_annotation_details', 
    TAGS_LIST: Config.BASE_POINT_API + 'fetch_tags', // get tags dropdown options
    SAVE_ANNOTATIONS: Config.BASE_POINT_API + 'save_tags', // save the edited annotations on popup
  };

  // Json Base Points
  public static JSON: any = {
    FILE_TABLE: Config.BASE_POINT_JSON + 'fileTable.json',
    SUBMIT_ALL_RECORDS: Config.BASE_POINT_JSON + 'fileTable.json',
    REQUEST_TABLE: Config.BASE_POINT_JSON + 'requestTable.json',
    ANNOTATIONS_DATA: Config.BASE_POINT_JSON + 'text.json',
    DELETE_ROW: Config.BASE_POINT_JSON + 'text.json',
    TAGS_LIST: Config.BASE_POINT_JSON + 'tagsList.json',
    SAVE_ANNOTATIONS: Config.BASE_POINT_JSON + 'text.json'
  };

  // SESSION RELATED CONSTANTS
  public static get SESSION_STATUS(): string { return 'sessionLoaded'; }
  public static get SESSION_TOKEN(): string { return 'sso_code'; }
  public static get ACCESS_TOKEN(): string { return 'access_token'; }
  public static get ID_TOKEN(): string { return 'id_token'; }
  public static get REFRESH_TOKEN(): string { return 'refresh_token'; }
  public static get USER_IDENTIFIER(): string { return 'UserId'; }
  public static get USER_ROLE(): string { return 'userRole'; }
  public static get NAME(): string { return 'name'; }
  public static get LOGIN_STATUS(): string { return 'IsLoggedin'; }
  public static get USER_DETAILS(): string { return 'userDetails'; }
  public static get SESSION_USER_NAME(): string { return 'UserName'; }
  public static get PAGE_ID(): string { return 'pageId'; }
  public static get LANGUAGE(): string { return 'language'; }
  public static get ROLE_OBJ(): string { return 'role_id'; }
  public static get DEFAULT_ACCOUNT_ID(): string { return 'account_id'; }
  public static get IS_APPROVER(): string { return 'is_approver'; }
  public static get GEOGRAPHY_ID(): string { return 'geography_id'; }
  public static get APPRVAL_REQUEST_ACCESS(): string { return 'approval_request_access'; }
  public static get DOMAIN_ID(): string { return 'domain_id'; }
  public static get DOMAIN_NAME(): string { return 'domain_name'; }
  public static get ROLE_TYPE_ID(): string { return 'role_type_id'; }
  public static get ROLE_TYPE_NAME(): string { return 'role_type_name'; }
  public static get IS_PREVIEW_INPROGRESS(): string { return 'is_preview_inprogress'; }
  public static get PREVIEW_SERVICE_SUCCESS(): string { return 'preview_service_success'; }
  public static get PREVIEW_DATA(): string { return 'preview_data'; }
  
  // Keys we need to use accross application. For logics and etc
  public static CONSTANTS: any = {
    STORAGE: {
      USER_ID: 'user_id',
      USER_NAME: 'user_name',
      USER_ROLE: 'user_role',
      USER_TYPE: 'user_type',
      USER_DETAILS: 'userDetails',
    },
  };

  // Version number
  // public static VERSION_NUMBER = APP_CONSTANTS.VERSION;

}
