import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { SimpleTableWithPaginationModule } from './simple-table-with-pagination/simple-table-with-pagination.module';
import { LoaderComponent } from './loader/loader.component';
import { ToastrComponent } from './toastr/toastr.component';
import { ToasterModule, ToasterService } from 'angular2-toaster';
import { LoaderServiceService } from './loader/loader-service.service';
import { TableServerSideModule } from './table-server-side/table-server-side.module';
import { AnnotateTextComponent } from './annotate-text/annotate-text.component';
import { NgxAnnotateTextModule } from 'ngx-annotate-text';
import { NgSelectModule } from '@ng-select/ng-select';
import { FormsModule } from '@angular/forms';



@NgModule({
  declarations: [
    LoaderComponent,
    ToastrComponent,
    AnnotateTextComponent,
  ],
  imports: [
    CommonModule,
    FormsModule,
    NgSelectModule,
    SimpleTableWithPaginationModule,
    ToasterModule,
    TableServerSideModule,
    NgxAnnotateTextModule
  ],
  exports:[
    SimpleTableWithPaginationModule,
    ToastrComponent,
    LoaderComponent,
    TableServerSideModule,
    AnnotateTextComponent
  ],
  providers: [ToasterService, LoaderServiceService],

})
export class CommonComponentsModule { }
