import { Component, OnInit, OnDestroy } from '@angular/core';

import { Subscription } from 'rxjs';
import { ToastrService } from './toastr.service';
import { ToastrState } from './toastr-state';

import { Toast, ToasterService, ToasterConfig, ToastType } from 'angular2-toaster';

@Component({
  selector: 'app-toastr',
  templateUrl: './toastr.component.html',
  styleUrls: ['./toastr.component.scss']
})
export class ToastrComponent implements OnInit, OnDestroy {

  public config1: ToasterConfig = new ToasterConfig({
    positionClass: 'toast-top-right',
    typeClasses: {

      error: 'custom-toast-error',
      info: 'custom-toast-info',
      wait: 'custom-toast-wait',
      success: 'custom-toast-success',
      warning: 'custom-toast-warning'
    },
    iconClasses: {
      error: 'custom-icon-error',
      info: 'custom-icon-info',
      wait: 'custom-icon-info',
      success: 'custom-icon-success',
      warning: 'custom-icon-warning'
    }
  });
  private subscription: Subscription;

  constructor(public toasterService: ToasterService, public toasterLoad: ToastrService) { }

  ngOnInit() {
    this.subscription = this.toasterLoad.loaderState.subscribe((toast: ToastrState) => {
      const trigger: Toast = {
        type: toast.type as ToastType,
        title: toast.title,
        body: toast.body,
        showCloseButton: toast.close,
      };
      if (toast.timeOut) {
        trigger.timeout = toast.timeOut;
      }
      this.toasterService.pop(trigger);
    });
  }

  ngOnDestroy(): void {
    // Called once, before the instance is destroyed.
    // Add 'implements OnDestroy' to the class.
    this.subscription.unsubscribe();
  }


}
