from scripts.logging.logger import logger
from scripts.db.mongo import mongo_client
from scripts.db.mongo.aggregates.site_conf import SiteConfAggregate
from scripts.db.mongo.collections.site_conf import SiteConf
from scripts.db.mongo.collections.tag_hierarchy import TagHierarchy


class UpdateHandler:
    def __init__(self):
        self.site_conf = SiteConf(mongo_client=mongo_client)
        self.tag_hierarchy = TagHierarchy(mongo_client=mongo_client)
        self.site_conf_aggregate = SiteConfAggregate

    def tag_hierarchy_update(self):
        status = True
        try:
            aggregate_query = self.site_conf_aggregate.aggregate_array
            details = []
            for each_query in aggregate_query:
                temp_details = list(self.site_conf.find_site_by_aggregate(each_query))
                details.extend(temp_details)
            logger.info("Records fetched from following collection Successfully")
            logger.info(f"database_name: {self.site_conf.database} collection_name: {self.site_conf.collection}")
            print("Records Fetched Successfully")
            try:
                self.tag_hierarchy.drop_tag_hierarchy_collection()
                logger.info(f"Dropped {self.tag_hierarchy.collection} collection from {self.site_conf.database} database")
                # for each_detail in details:
                self.tag_hierarchy.insert_many_tag_hierarchy(details)
                logger.info("Updated the following collection Successfully")
                logger.info(
                    f"database_name: {self.site_conf.database} collection_name: {self.tag_hierarchy.collection}")
                print("Updated the collection Successfully")
            except Exception as e:
                logger.exception(str(e))
                status = False
            return status
        except Exception as e:
            logger.exception(str(e))
            raise
