class SiteConfAggregate:
    aggregate_array = [
        [
            {
                '$unwind': '$site_info.tags'
            },
            {
                '$project': {
                    '_id': 0,
                    'project_id': '$customer_project_id',
                    'site_id': '$site_id',
                    'site_name': '$site_name',
                    'parameter_id': '$site_info.tags.value',
                    'dept_id': '',
                    'dept_name': '',
                    'line_id': '',
                    'line_name': '',
                    'equipment_id': '',
                    'equipment_name': '',
                    'id': {
                        '$concat': [
                            '$site_id', {
                                '$literal': '$'
                            }, '$site_info.tags.value'
                        ]
                    },
                    'thing_model_id': '',
                    'thing_model_version': ''
                }
            }
        ],
        [
            {
                '$match': {
                    'dept': {
                        '$exists': True
                    }
                }
            }, {
            '$unwind': '$dept'
        }, {
            '$unwind': '$dept.tags'
        }, {
            '$project': {
                '_id': 0,
                'project_id': '$customer_project_id',
                'site_id': '$site_id',
                'site_name': '$site_name',
                'parameter_id': '$dept.tags.value',
                'dept_id': '$dept.dept_id',
                'dept_name': '$dept.dept_name',
                'line_id': '',
                'line_name': '',
                'equipment_id': '',
                'equipment_name': '',
                'id': {
                    '$concat': [
                        '$site_id', {
                            '$literal': '$'
                        }, '$dept.dept_id', {
                            '$literal': '$'
                        }, '$dept.tags.value'
                    ]
                },
                'thing_model_id': '',
                'thing_model_version': ''
            }
        }
        ],
        [
            {
                '$match': {
                    'dept': {
                        '$exists': False
                    },
                    'line': {
                        '$exists': True
                    }
                }
            }, {
            '$unwind': '$line'
        }, {
            '$unwind': '$line.tags'
        }, {
            '$project': {
                '_id': 0,
                'project_id': '$customer_project_id',
                'site_id': '$site_id',
                'site_name': '$site_name',
                'parameter_id': '$line.tags.value',
                'dept_id': '',
                'dept_name': '',
                'line_id': '$line.line_id',
                'line_name': '$line.line_name',
                'equipment_id': '',
                'equipment_name': '',
                'id': {
                    '$concat': [
                        '$site_id', {
                            '$literal': '$'
                        }, '$line.line_id', {
                            '$literal': '$'
                        }, '$line.tags.value'
                    ]
                },
                'thing_model_id': '',
                'thing_model_version': ''
            }
        }
        ],
        [
            {
                '$match': {
                    'dept': {
                        '$exists': True
                    },
                    'line': {
                        '$exists': True
                    }
                }
            }, {
            '$unwind': '$line'
        }, {
            '$unwind': '$line.tags'
        }, {
            '$project': {
                '_id': 0,
                'project_id': '$customer_project_id',
                'site_id': '$site_id',
                'site_name': '$site_name',
                'parameter_id': '$line.tags.value',
                'dept_id': '$line.dept_id',
                'dept_name': {
                    '$arrayElemAt': [
                        '$dept.dept_name', {
                            '$indexOfArray': [
                                '$dept.dept_id', '$line.dept_id'
                            ]
                        }
                    ]
                },
                'line_id': '$line.line_id',
                'line_name': '$line.line_name',
                'equipment_id': '',
                'equipment_name': '',
                'id': {
                    '$concat': [
                        '$site_id', {
                            '$literal': '$'
                        }, '$line.dept_id', {
                            '$literal': '$'
                        }, '$line.line_id', {
                            '$literal': '$'
                        }, '$line.tags.value'
                    ]
                },
                'thing_model_id': '',
                'thing_model_version': ''
            }
        }
        ],
        [
            {
                '$match': {
                    'dept': {
                        '$exists': False
                    },
                    'line': {
                        '$exists': False
                    },
                    'equipment': {
                        '$exists': True
                    }
                }
            }, {
            '$unwind': '$equipment'
        }, {
            '$unwind': '$equipment.tags'
        }, {
            '$project': {
                '_id': 0,
                'project_id': '$customer_project_id',
                'site_id': '$site_id',
                'site_name': '$site_name',
                'parameter_id': '$equipment.tags.value',
                'dept_id': '',
                'dept_name': '',
                'line_id': '',
                'line_name': '',
                'equipment_id': '$equipment.equipment_id',
                'equipment_name': '$equipment.equipment_name',
                'id': {
                    '$concat': [
                        '$site_id', {
                            '$literal': '$'
                        }, '$equipment.equipment_id', {
                            '$literal': '$'
                        }, '$equipment.tags.value'
                    ]
                },
                'thing_model_id': {
                    '$cond': {
                        'if': {
                            '$eq': [
                                '$equipment.associate_type', 'associate_thing_model'
                            ]
                        },
                        'then': {
                            '$arrayElemAt': [
                                {
                                    '$split': [
                                        '$equipment.thing_model', {
                                            '$literal': '$'
                                        }
                                    ]
                                }, 0
                            ]
                        },
                        'else': ''
                    }
                },
                'thing_model_version': {
                    '$cond': {
                        'if': {
                            '$eq': [
                                '$equipment.associate_type', 'associate_thing_model'
                            ]
                        },
                        'then': {
                            '$toDouble': {
                                '$arrayElemAt': [
                                    {
                                        '$split': [
                                            '$equipment.thing_model', {
                                                '$literal': '$'
                                            }
                                        ]
                                    }, 1
                                ]
                            }
                        },
                        'else': ''
                    }
                }
            }
        }
        ],
        [
            {
                '$match': {
                    'dept': {
                        '$exists': False
                    },
                    'line': {
                        '$exists': True
                    },
                    'equipment': {
                        '$exists': True
                    }
                }
            }, {
            '$unwind': '$equipment'
        }, {
            '$unwind': '$equipment.tags'
        }, {
            '$project': {
                '_id': 0,
                'project_id': '$customer_project_id',
                'site_id': '$site_id',
                'site_name': '$site_name',
                'parameter_id': '$equipment.tags.value',
                'dept_id': '',
                'dept_name': '',
                'line_id': '$equipment.line_id',
                'line_name': {
                    '$arrayElemAt': [
                        '$line.line_name', {
                            '$indexOfArray': [
                                '$line.line_id', '$equipment.line_id'
                            ]
                        }
                    ]
                },
                'equipment_id': '$equipment.equipment_id',
                'equipment_name': '$equipment.equipment_name',
                'id': {
                    '$concat': [
                        '$site_id', {
                            '$literal': '$'
                        }, '$equipment.line_id', {
                            '$literal': '$'
                        }, '$equipment.equipment_id', {
                            '$literal': '$'
                        }, '$equipment.tags.value'
                    ]
                },
                'thing_model_id': {
                    '$cond': {
                        'if': {
                            '$eq': [
                                '$equipment.associate_type', 'associate_thing_model'
                            ]
                        },
                        'then': {
                            '$arrayElemAt': [
                                {
                                    '$split': [
                                        '$equipment.thing_model', {
                                            '$literal': '$'
                                        }
                                    ]
                                }, 0
                            ]
                        },
                        'else': ''
                    }
                },
                'thing_model_version': {
                    '$cond': {
                        'if': {
                            '$eq': [
                                '$equipment.associate_type', 'associate_thing_model'
                            ]
                        },
                        'then': {
                            '$toDouble': {
                                '$arrayElemAt': [
                                    {
                                        '$split': [
                                            '$equipment.thing_model', {
                                                '$literal': '$'
                                            }
                                        ]
                                    }, 1
                                ]
                            }
                        },
                        'else': ''
                    }
                }
            }
        }
        ],
        [
            {
                '$match': {
                    'dept': {
                        '$exists': True
                    },
                    'line': {
                        '$exists': True
                    },
                    'equipment': {
                        '$exists': True
                    }
                }
            }, {
            '$unwind': '$equipment'
        }, {
            '$unwind': '$equipment.tags'
        }, {
            '$project': {
                '_id': 0,
                'project_id': '$customer_project_id',
                'site_id': '$site_id',
                'site_name': '$site_name',
                'parameter_id': '$equipment.tags.value',
                'dept_id': '$equipment.dept_id',
                'dept_name': {
                    '$arrayElemAt': [
                        '$dept.dept_name', {
                            '$indexOfArray': [
                                '$dept.dept_id', '$equipment.dept_id'
                            ]
                        }
                    ]
                },
                'line_id': '$equipment.line_id',
                'line_name': {
                    '$arrayElemAt': [
                        '$line.line_name', {
                            '$indexOfArray': [
                                '$line.line_id', '$equipment.line_id'
                            ]
                        }
                    ]
                },
                'equipment_id': '$equipment.equipment_id',
                'equipment_name': '$equipment.equipment_name',
                'id': {
                    '$concat': [
                        '$site_id', {
                            '$literal': '$'
                        }, '$equipment.dept_id', {
                            '$literal': '$'
                        }, '$equipment.line_id', {
                            '$literal': '$'
                        }, '$equipment.equipment_id', {
                            '$literal': '$'
                        }, '$equipment.tags.value'
                    ]
                },
                'thing_model_id': {
                    '$cond': {
                        'if': {
                            '$eq': [
                                '$equipment.associate_type', 'associate_thing_model'
                            ]
                        },
                        'then': {
                            '$arrayElemAt': [
                                {
                                    '$split': [
                                        '$equipment.thing_model', {
                                            '$literal': '$'
                                        }
                                    ]
                                }, 0
                            ]
                        },
                        'else': ''
                    }
                },
                'thing_model_version': {
                    '$cond': {
                        'if': {
                            '$eq': [
                                '$equipment.associate_type', 'associate_thing_model'
                            ]
                        },
                        'then': {
                            '$toDouble': {
                                '$arrayElemAt': [
                                    {
                                        '$split': [
                                            '$equipment.thing_model', {
                                                '$literal': '$'
                                            }
                                        ]
                                    }, 1
                                ]
                            }
                        },
                        'else': ''
                    }
                }
            }
        }
        ]
    ]
