from scripts.constants import DatabaseNames, CollectionNames, TagHierarchyKeys
from scripts.utils.mongo_util import MongoCollectionBaseClass


class TagHierarchy(MongoCollectionBaseClass):
    def __init__(self, mongo_client):
        super().__init__(mongo_client, database=DatabaseNames.ilens_configuration,
                         collection=CollectionNames.tag_hierarchy)

    @property
    def key_id(self):
        return TagHierarchyKeys.KEY_ID

    @property
    def key_site_id(self):
        return TagHierarchyKeys.KEY_SITE_ID

    @property
    def key_dept_id(self):
        return TagHierarchyKeys.KEY_DEPT_ID

    @property
    def key_line_id(self):
        return TagHierarchyKeys.KEY_LINE_ID

    @property
    def key_equipment_id(self):
        return TagHierarchyKeys.KEY_EQUIPMENT_ID

    @property
    def key_parameter_id(self):
        return TagHierarchyKeys.KEY_PARAMETER_ID

    @property
    def key_thing_model_id(self):
        return TagHierarchyKeys.KEY_THING_MODEL_ID

    @property
    def key_thing_model_version(self):
        return TagHierarchyKeys.KEY_THING_MODEL_VERSION

    @property
    def key_dept_name(self):
        return TagHierarchyKeys.KEY_DEPT_NAME

    @property
    def key_site_name(self):
        return TagHierarchyKeys.KEY_SITE_NAME

    @property
    def key_line_name(self):
        return TagHierarchyKeys.KEY_LINE_NAME

    @property
    def key_equipment_name(self):
        return TagHierarchyKeys.KEY_EQUIPMENT_NAME

    @property
    def key_project_id(self):
        return TagHierarchyKeys.KEY_PROJECT_ID

    def find_all_tag_hierarchy(self, filter_dict=None,
                               sort=None, skip=0, limit=None, query=None):
        """
        The following function will give all tag_hierarchy for the given set of
        search parameters as keyword arguments
        :param filter_dict:
        :param sort:
        :param skip:
        :param limit:
        :param query:
        :return:
        """
        if query is None:
            query = {}
        all_tag_hierarchy = self.find(filter_dict=filter_dict, sort=sort, skip=skip, limit=limit, query=query)
        if not all_tag_hierarchy:
            return list()
        return list(all_tag_hierarchy)

    def find_one_tag_hierarchy(self, filter_dict=None, **query):
        """
        The following function will give one tag_hierarchy for a given set of
        search parameters as keyword arguments
        :param filter_dict:
        :param query:
        :return:
        """
        tag_hierarchy = self.find_one(filter_dict=filter_dict, query=query)
        if tag_hierarchy:
            return tag_hierarchy
        else:
            return {}

    def insert_one_tag_hierarchy(self, data):
        """
        The following function will insert one tag_hierarchy in the
        tag_hierarchy collections
        :param data:
        :return:
        """
        return self.insert_one(data)

    def insert_many_tag_hierarchy(self, data):
        """
        The following function will insert many tag_hierarchy in the
        tag_hierarchy collection
        :param data:
        :return:
        """
        return self.insert_many(data)

    def update_one_tag_hierarchy(self, query, data, upsert=False):
        """
        The following function will update one tag_hierarchy in
        tag_hierarchy collection based on the given query
        :param query:
        :param data:
        :param upsert:
        :return:
        """
        return self.update_one(data=data, upsert=upsert, query=query)

    def update_many_tag_hierarchy(self, data, query, upsert=False):
        """
        The following function will update many tag_hierarchy in
        tag_hierarchy collection based on the given query
        :param data:
        :param upsert:
        :param query:
        :return:
        """
        return self.update_many(data=data, upsert=upsert, query=query)

    def delete_many_tag_hierarchy(self, query):
        """
        The following function will delete many tag_hierarchy in
        tag_hierarchy collection based on the given query
        :param query:
        :return:
        """
        return self.delete_many(query=query)

    def delete_one_tag_hierarchy(self, **query):
        """
        The following function will delete one tag_hierarchy in
        tag_hierarchy collection based on the given query
        :param query:
        :return:
        """
        return self.delete_one(query=query)

