class TagsAggregate:
    tag_id_name_map = [
        {
            '$group': {
                '_id': None,
                'tag_id_name': {
                    '$push': {
                        'k': '$id',
                        'v': '$tag_name'
                    }
                }
            }
        }, {
            '$project': {
                '_id': 0,
                'tag_id_name': {
                    '$arrayToObject': '$tag_id_name'
                }
            }
        }
    ]

    derived_tags_list = [{"$match": {'system_tag_type': 'derived_tag'}},
                         {"$group": {"_id": None, "derived_tag_list": {"$push": "$id"}}},
                         {"$project": {"derived_tag_list": "$derived_tag_list"}}]
