from scripts.errors.module_exceptions import RequiredFieldsMissing
from scripts.logging.logger import logger
from scripts.handler.rule_engine_update import RuleUpdate

if __name__ == '__main__':
    try:
        logger.debug("main block started")
        # status = RuleUpdate().rule_update(request_payload)
        # status = RuleUpdate().fetch_hireares('MODBUS_DELTA_UPDATED')
        lst = [["rule_errorcode_1", "tag_194", "tag_352", "rule_engine_131"],
               ["rule_errorcode_2", "tag_197", "tag_353", "rule_engine_132"],
               ["rule_errorcode_3", "tag_200", "tag_354", "rule_engine_133"],
               ["rule_errorcode_4", "tag_202", "tag_355", "rule_engine_134"],
               ["rule_errorcode_5", "tag_205", "tag_356", "rule_engine_135"],
               ["rule_errorcode_6", "tag_207", "tag_357", "rule_engine_136"],
               ["rule_errorcode_7", "tag_208", "tag_358", "rule_engine_137"],
               ["rule_errorcode_8", "tag_209", "tag_359", "rule_engine_139"],
               ["rule_errorcode_9", "tag_210", "tag_360", "rule_engine_140"]]
        for each in lst:
            status = RuleUpdate().fetch_hireares('MODBUS_DELTA_UPDATED',
                                                 each[0].split('rule_')[1],
                                                 input_tag=each[1],
                                                 output_tag=each[2],
                                                 rule_id=each[-1],
                                                 lookup_name=each[0])
            # status = RuleUpdate().rule_update(request_payload, 'error_code_1')
            if status.get('status') == 'success':
                print(f"Created successfully: {each}")
            else:
                print("Some records are not created successfully, Please check the log file")
    except RequiredFieldsMissing:
        logger.exception("Required Fields are missing in the static JSON")
        print("Required Fields are missing in the static JSON")
    except Exception as e:
        logger.exception("Exception in the main block" + str(e))
        print("Exception in the main block" + str(e))
