from scripts.db.mongo import mongo_client
from scripts.db.mongo.ilens_configuration.collections.unique_id import UniqueId, UniqueIdSchema
from scripts.logging.logger import logger


class CommonUtils:

    def __init__(self):
        self.unique = UniqueId(mongo_client=mongo_client)

    def get_next_id(self, param1):
        my_doc = self.unique.find_one_record(key=param1)
        if not my_doc:
            my_dict = UniqueIdSchema(key=param1, id="100")

            self.unique.insert_record(my_dict)
            return my_dict.id
        else:
            my_doc = [self.unique.find_record(param1, {"_id": 0, "id": 1})]
            for each_document in my_doc:
                count_value = str(int(each_document['id']) + 1)
                new_values = {"id": count_value}
                self.unique.update_one_record(param1, new_values)
                return str(int(each_document['id']) + 1)

    @staticmethod
    def get_usr_id(input_data=None):
        """
        Definition for getting the user id
        :param input_data:
        :return:
        """
        user_id = None
        try:
            if "user_id" in input_data and input_data["user_id"] != "":
                user_id = input_data["user_id"]
                return user_id
            else:
                return user_id
        except Exception as e:
            logger.exception(str(e))
        return user_id
