from copy import deepcopy

from scripts.logging.logger import logger
from scripts.db.mongo import mongo_client
from scripts.db.mongo.ilens_configuration.aggregates.tags import TagsAggregate
from scripts.db.mongo.ilens_configuration.collections.tags import Tags
from scripts.db.mongo.ilens_configuration.collections.site_conf import SiteConf
from scripts.db.mongo.ilens_configuration.aggregates.site_conf import SiteConfAggregate
from scripts.handler.rule_configuration_handler import RuleConfigurationHandler
from scripts.errors.module_exceptions import RequiredFieldsMissing


class RuleUpdate:
    def __init__(self):
        self.tags_mongo = Tags(mongo_client=mongo_client)
        self.tags_aggregate = TagsAggregate
        self.sites_mongo = SiteConf(mongo_client=mongo_client)
        self.sites_aggregate = SiteConfAggregate
        self.rule_configuration_handler = RuleConfigurationHandler()

    def rule_update(self):
        try:
            request_payload = [{
                "lookup_name": "Rule_lookup_one",
                "match_type": "exact",
                "hierarchy_ste": ["[Kite:AC VOLTAGE-1]",
                                  "[Kite:Temperature]"],
                "complete_tag_id": "tag_36980",
                "selected_tags": [
                    "site_305$tag_125",
                    "site_305$tag_100"
                ],
                "output_device": ["site_305"]
            },
                {
                    "lookup_name": "Rule_lookup_two",
                    "match_type": "exact",
                    "hierarchy_ste": "[Kite:AC VOLTAGE-1]",
                    "complete_tag_id": "tag_36980",
                    "selected_tags": ["site_305$tag_125"],
                    "output_devices": [
                        "site_305"
                    ]

                }]
            static_json = {
                "rule_engine_id": "",
                "Selected_device": [],
                "Selected_ruleType": "",  # todo
                "calcFormulaList": [],
                "deviceDescription": "",  # todo
                "disable_all": "",  # todo --> bool
                "execute_on": {},  # todo --> Optional
                "processOn": "",  # todo
                "project_id": "project_099",  # todo
                "ruleName": "",  # todo
                "schedule": "",  # todo  --> bool --> Optional
                "selected_device_meta": {},  # todo --> Optional
                "transformation_type": "",  # todo --> Optional
                "user_id": "",  # todo
                "status": ""  # todo --> Optional
            }
            required_fields = ["Selected_ruleType", "deviceDescription", "disable_all",
                               "processOn", "project_id", "ruleName", "user_id"]  # required fields
            for each_rule_index, each_rule in enumerate(request_payload):
                static_calc_form_json = {
                    "code": "",
                    "parsedCode": {
                        "type": "Program",
                        "body": [
                            {
                                "type": "ExpressionStatement",
                                "expression": {
                                    "type": "CallExpression",
                                    "callee": {
                                        "type": "Identifier",
                                        "name": "lookup"
                                    },
                                    "arguments": []
                                }
                            }
                        ],
                        "sourceType": "script"
                    },
                    "_previewValue": "NA",
                    "calcuationValidObject": {
                        "status": True,
                        "message": "Correct , Valid rule"
                    },
                    "completeTagId": "",
                    "selectedTags": [],
                    "previousTags": [],
                    "output_devices": [],
                    "output_type": [
                        "data_store"
                    ],
                    "mqtt": {
                        "topic": None
                    },
                    "kafka": {
                        "topic": None
                    },
                    "rest": {
                        "url": None,
                        "request_type": None,
                        "payload": None
                    },
                    "data_store": {},
                    "output_tags": [],
                    "disable": False,
                    "execute_on_tag": [],
                    "block_id": "",
                    "rule_block_parent": [],
                    "execute_on": {},
                    "completeTagName": ""
                }
                identifier_dict = {
                    "type": "Identifier",
                    "name": ""
                }
                literal_dict = {
                    "type": "Literal",
                    "value": "",
                    "raw": ""
                }
                selected_device_dict = {
                    "id": "",
                    "itemName": ""
                }
                code_name = ""
                if isinstance(each_rule.get("hierarchy_ste"), list):
                    for each_hierarchy_ste in each_rule.get("hierarchy_ste", []):
                        if code_name == "":
                            code_name += each_hierarchy_ste
                        else:
                            code_name += ", " + each_hierarchy_ste
                else:
                    code_name += each_rule.get("hierarchy_ste")
                code_name += ", " + "'" + each_rule.get("lookup_name", "") + "'"
                code_name += ", " + "'" + each_rule.get("match_type", "") + "'"
                static_calc_form_json["code"] = "lookup" + "(" + code_name + ")"
                if isinstance(each_rule.get("selected_tags"), list):
                    for each_hierarchy in each_rule.get("selected_tags", []):
                        identifier_dict["name"] = each_hierarchy
                        static_calc_form_json["parsedCode"]["body"][0]["expression"]["arguments"].append(
                            deepcopy(identifier_dict))
                else:
                    identifier_dict["name"] = each_rule.get("selected_tags", "")
                    static_calc_form_json["parsedCode"]["body"][0]["expression"]["arguments"].append(
                        deepcopy(identifier_dict))
                literal_dict["value"] = each_rule.get("lookup_name", "")
                literal_dict["raw"] = "'" + each_rule.get("lookup_name", "") + "'"
                static_calc_form_json["parsedCode"]["body"][0]["expression"]["arguments"].append(deepcopy(literal_dict))
                literal_dict["value"] = each_rule.get("match_type", "")
                literal_dict["raw"] = "'" + each_rule.get("match_type", "") + "'"
                static_calc_form_json["parsedCode"]["body"][0]["expression"]["arguments"].append(deepcopy(literal_dict))
                static_calc_form_json["completeTagId"] = each_rule.get("complete_tag_id")
                static_calc_form_json["selectedTags"] = each_rule.get("selected_tags", [])
                static_calc_form_json["previousTags"] = each_rule.get("selected_tags", [])
                static_calc_form_json["output_devices"] = each_rule.get("output_devices", [])
                if each_rule.get("complete_tag_name"):
                    static_calc_form_json["completeTagName"] = each_rule.get("complete_tag_name")
                else:
                    complete_tag_name_query = self.tags_aggregate.tag_id_name_map
                    complete_tag_name = self.tags_mongo.find_by_aggregate(complete_tag_name_query)
                    if complete_tag_name:
                        complete_tag_name = complete_tag_name[0]
                    static_calc_form_json["completeTagName"] = complete_tag_name["tag_id_name"][
                        each_rule.get("complete_tag_id")]
                block_id = "block_" + str((each_rule_index + 1))
                static_calc_form_json["block_id"] = block_id
                static_json["calcFormulaList"].append(static_calc_form_json)
                for each_selected_tags in each_rule.get("selected_tags", []):
                    selected_device_array = each_selected_tags.split("$tag")
                    if selected_device_array:
                        selected_device = selected_device_array[0]
                        selected_device_dict["id"] = selected_device
                        device_exist = False
                        for each_selected_device in static_json.get("Selected_device", []):
                            if selected_device_dict["id"] == each_selected_device.get("id"):
                                device_exist = True
                        if not device_exist:
                            hierarchy_name_array = selected_device_dict["id"].split("$")
                            request_dict = {"project_id": static_json["project_id"]}
                            for each_level in hierarchy_name_array:
                                if 'site' in each_level:
                                    request_dict.update({"site_id": each_level})
                                elif 'dept' in each_level:
                                    request_dict.update({"dept_id": each_level})
                                elif 'line' in each_level:
                                    request_dict.update({"line_id": each_level})
                                elif 'equipment' in each_level:
                                    request_dict.update({"equipment_id": each_level})
                            name_hierarchy_query = self.sites_aggregate.find_hierarchy_name(request_dict)
                            name_hierarchy = self.sites_mongo.find_site_by_aggregate(name_hierarchy_query)
                            if name_hierarchy:
                                name_hierarchy = name_hierarchy[0]
                            selected_device_dict["itemName"] = name_hierarchy.get("itemName")
                            static_json["Selected_device"].append(deepcopy(selected_device_dict))
            for each_required_field in required_fields:
                if not static_json.get(each_required_field):
                    raise RequiredFieldsMissing  # Raise error if required fields are not filled
            print(static_json)
            return_json = self.rule_configuration_handler.create_rule_engine(static_json)
            print(return_json)
        except Exception as e:
            logger.exception(str(e))
            raise
