from typing import Optional, List

from scripts.constants import DatabaseNames, CollectionNames
from scripts.utils.mongo_util import MongoCollectionBaseClass


class RuleEngine(MongoCollectionBaseClass):
    def __init__(self, mongo_client):
        super().__init__(mongo_client, database=DatabaseNames.ilens_configuration,
                         collection=CollectionNames.rule_engine)

    def find_all_rules(self, query):
        """
        The following function will give all rules for the given set of
        search parameters as keyword arguments
        :return:
        """
        all_rules = self.find(query)
        if not all_rules:
            return list()
        return list(all_rules)

    def find_one_rule(self, query):
        """
        The following function will give all rules for the given set of
        search parameters as keyword arguments
        :param query:
        :return:
        """
        selected_rule = self.find_one(query=query)
        if selected_rule:
            return selected_rule
        return dict()

    def update_one_rule(self, query_dict, data, upsert=False):
        """
        The following function will update one rule in
        tags collection based on the given query
        """
        return self.update_one(data=data, query=query_dict, upsert=upsert)

    def insert_one_rule(self, data):
        return self.insert_one(data)

    def delete_one_rule(self, query):
        """
        The following function will delete one rule in
        tags collection based on the given query
        """
        return self.delete_one(query=query)

