from copy import deepcopy

from scripts.logging.logger import logger
from scripts.db.mongo import mongo_client
from scripts.db.mongo.ilens_configuration.aggregates.tags import TagsAggregate
from scripts.db.mongo.ilens_configuration.collections.tags import Tags
from scripts.db.mongo.ilens_configuration.collections.site_conf import SiteConf
from scripts.db.mongo.ilens_configuration.aggregates.site_conf import SiteConfAggregate
from scripts.handler.rule_configuration_handler import RuleConfigurationHandler
from scripts.errors.module_exceptions import RequiredFieldsMissing

hirearchy_name_mapping = {}


class RuleUpdate:
    def __init__(self):
        self.tags_mongo = Tags(mongo_client=mongo_client)
        self.tags_aggregate = TagsAggregate
        self.sites_mongo = SiteConf(mongo_client=mongo_client)
        self.sites_aggregate = SiteConfAggregate
        self.rule_configuration_handler = RuleConfigurationHandler()
        self.assign_hirearchies = []
        self.hirearchy_name_mapping = {}

    def fetch_hireares(self, model_id, errr_name, input_tag, output_tag, rule_id, lookup_name):
        final_json = {}
        try:
            final_json["data"] = []
            each_site = self.sites_mongo.find_site_by_site_id(site_id='site_101')
            try:
                dept_exists = False
                dept_mapping = {}
                line_mapping = {}
                line_exists = False
                hire_str_label = each_site['site_id']
                hire_str_value = each_site['site_info']['site_name']
                self.tag_update(each_site['site_info']['tags'], hire_str_label, hire_str_value)
                if "dept" in each_site and each_site["dept"]:
                    dept_exists = True
                    for each_dept in each_site["dept"]:
                        temp_hire_str_value = f"{hire_str_value}>{each_dept['dept_name']}"
                        temp_hire_str_label = f"{hire_str_label}${each_dept['dept_id']}"
                        dept_mapping[each_dept['dept_id']] = each_dept['dept_name']
                        self.tag_update(each_dept['tags'], temp_hire_str_label, temp_hire_str_value)
                if "line" in each_site and each_site['line']:
                    for each_line in each_site['line']:
                        line_exists = True
                        try:
                            line_mapping[each_line['line_id']] = each_line['line_name']
                            if dept_exists:
                                temp_hire_str_value = f"{hire_str_value}>{dept_mapping[each_line['dept_id']]}>{each_line['line_name']}"
                                temp_hire_str_label = f"{hire_str_label}${each_line['dept_id']}${each_line['line_id']}"
                            else:
                                temp_hire_str_value = f"{hire_str_value}>{each_line['line_name']}"
                                temp_hire_str_label = f"{hire_str_label}${each_line['line_id']}"
                            self.tag_update(each_line['tags'], temp_hire_str_label, temp_hire_str_value)
                        except Exception as e:
                            logger.exception(e)
                if "equipment" in each_site and each_site['equipment']:
                    for each_equip in each_site['equipment']:
                        try:
                            eq_hir_str = hire_str_value
                            eq_hir_id = hire_str_label
                            if dept_exists:
                                eq_hir_str = eq_hir_str + f">{dept_mapping[each_equip['dept_id']]}"
                                eq_hir_id = eq_hir_id + f"${each_equip['dept_id']}"

                            if line_exists:
                                eq_hir_str = eq_hir_str + f">{line_mapping[each_equip['line_id']]}"
                                eq_hir_id = eq_hir_id + f"${each_equip['line_id']}"
                            eq_hir_str = eq_hir_str + f">{each_equip['equipment_name']}"
                            eq_hir_id = eq_hir_id + f"${each_equip['equipment_id']}"
                            if each_equip['make_model'].lower() == model_id.lower():  # todo
                                self.assign_hirearchies.append([eq_hir_str, eq_hir_id])
                            self.tag_update(each_equip['tags'], eq_hir_id, eq_hir_str)
                        except Exception as e:
                            logger.exception(e)
            except Exception as e:
                logger.exception(str(e))
            selected_list = []
            for each in self.assign_hirearchies:
                selected_list.append({
                    "id": each[1],
                    "itemName": each[0]
                })
            status = self.form_insert_json(errr_name, selected_list, input_tag, output_tag, rule_id, lookup_name)
        except Exception as e:
            logger.exception(e)
            status = {'status': 'Failed'}
        return status

    def tag_update(self, tag_list, hire_id, hire_str):
        self.hirearchy_name_mapping[hire_id] = hire_str
        for each_tag in tag_list:
            self.hirearchy_name_mapping[f"{hire_id}${each_tag['value']}"] = \
                f"{hire_str}:{each_tag['label']}"

    def form_insert_json(self, errr_name, selected_list, input_tag, output_tag, rule_id, lookup_name):
        final_insert_list = []
        c = 0
        for each_hi in self.assign_hirearchies:
            try:
                final_insert_list.append({
                    "lookup_name": lookup_name,
                    "match_type": "exact",
                    "hierarchy_ste": [
                        self.hirearchy_name_mapping[f"{each_hi[1]}${input_tag}"]
                    ],
                    "complete_tag_id": output_tag,
                    "selected_tags": [
                        f"{each_hi[1]}${input_tag}"
                    ],
                    "output_device": [
                        each_hi[1]
                    ]
                })
            except Exception as e:
                c += 1
                logger.info(f"No Mapping: {e} - {c}")
                logger.exception(e)
        status = self.rule_update(final_insert_list, errr_name, selected_list, rule_id)
        return status

    def rule_update(self, request_payload, rulename, selected_list, rule_id):
        try:
            project_id = "project_101"
            user_id = "user_100"
            static_json = {
                "rule_engine_id": rule_id,
                "Selected_device": selected_list,
                "Selected_ruleType": "Real Time",
                "calcFormulaList": [],
                "deviceDescription": f"Manually created rule from code for lookup - {rulename}",  # todo
                "disable_all": False,
                "execute_on": {},
                "processOn": "server",
                "project_id": project_id,  # todo
                "ruleName": f"Lookup-{rulename}",  # todo
                "selected_device_meta": {},
                "transformation_type": "validation_and_transformation",
                "user_id": user_id,
                "tz": "Asia/Kolkata",
                "language": "en"
            }
            for each_rule_index, each_rule in enumerate(request_payload):
                static_calc_form_json = {}
                static_calc_form_json = {
                    "code": f"lookup({each_rule['hierarchy_ste']}, '{each_rule['lookup_name']}', 'exact')",
                    "parsedCode": {
                        "type": "Program",
                        "body": [
                            {
                                "type": "ExpressionStatement",
                                "expression": {
                                    "type": "CallExpression",
                                    "callee": {
                                        "type": "Identifier",
                                        "name": "lookup"
                                    },
                                    "arguments": [
                                        {
                                            "type": "Identifier",
                                            "name": each_rule['selected_tags'][0]
                                        },
                                        {
                                            "type": "Literal",
                                            "value": each_rule['lookup_name'],
                                            "raw": f"'{each_rule['lookup_name']}'"
                                        },
                                        {
                                            "type": "Literal",
                                            "value": "match-type",
                                            "raw": "'match-type'"
                                        }
                                    ]
                                }
                            }
                        ],
                        "sourceType": "script"
                    },
                    "_previewValue": "NA",
                    "calcuationValidObject": {
                        "status": True,
                        "message": "Correct , Valid rule"
                    },
                    "completeTagId": each_rule['complete_tag_id'],
                    "selectedTags": each_rule['selected_tags'],
                    "previousTags": each_rule['selected_tags'],
                    "output_devices": each_rule['output_device'],
                    "output_type": [
                        "data_store"
                    ],
                    "mqtt": {
                        "topic": None
                    },
                    "kafka": {
                        "topic": None
                    },
                    "rest": {
                        "url": None,
                        "request_type": None,
                        "payload": None
                    },
                    "data_store": {},
                    "output_tags": [],
                    "disable": False,
                    "execute_on_tag": [],
                    "rule_block_parent": [],
                    "execute_on": {}
                }
                static_json['calcFormulaList'].append(static_calc_form_json)
            # print(static_json)
            return_json = self.rule_configuration_handler.create_rule_engine(static_json)
            logger.info(return_json)
        except Exception as e:
            logger.exception(str(e))
            raise
        return {'status':'success'}
        # return return_json
