class SiteConfAggregate:
    @staticmethod
    def find_hierarchy_name(input_data):
        id_match_dict = dict()
        name_project_dict = {'_id': 0, 'site_name': 1}
        concat_project_list = ['$site_name']
        if input_data.get("dept_id"):
            id_match_dict.update({'dept.dept_id': input_data["dept_id"]})
            name_project_dict.update({"dept_name": "$dept.dept_name"})
            concat_project_list.append('>')
            concat_project_list.append('$dept_name')
        if input_data.get("line_id"):
            id_match_dict.update({'line.line_id': input_data["line_id"]})
            name_project_dict.update({"line_name": "$line.line_name"})
            concat_project_list.append('>')
            concat_project_list.append('$line_name')
        if input_data.get('equipment_id'):
            id_match_dict.update({'equipment.equipment_id': input_data["equipment_id"]})
            name_project_dict.update({"equipment_name": "$equipment.equipment_name"})
            concat_project_list.append('>')
            concat_project_list.append('$equipment_name')
        query = [
            {
                '$match': {
                    'customer_project_id': input_data["project_id"],
                    'site_id': input_data["site_id"]
                }
            }, {
                '$unwind': '$line'
            }, {
                '$unwind': '$equipment'
            }, {
                '$match': id_match_dict
            }, {
                '$project': name_project_dict
            }, {
                '$project': {
                    'itemName': {
                        '$concat': concat_project_list
                    }
                }
            }
        ]
        return query
