import uvicorn
from fastapi import FastAPI
from dotenv import load_dotenv
import script

load_dotenv()

from script.config.app_config import Service
from script.service.weather import router

app = FastAPI(title="Weather")
app.include_router(router)

if __name__ == "__main__":
    uvicorn.run("main:app", host=script.config.app_config.Service.host, port=script.config.app_config.Service.port)
