from fastapi import FastAPI, File, UploadFile, APIRouter
import pandas as pd
from io import StringIO
import logging
from script.constant import APIEndpoints
from script.core.handlers.weather_connection import WeatherReport
from script.core.schema.response import DefaultResponse

router = APIRouter(prefix=APIEndpoints.report_base)

data = None


@router.post("/upload")
def upload_file(file: UploadFile = File(...)):
    contents = file.file.read()
    s = str(contents, 'utf-8')
    raw_data = StringIO(s)
    global data
    data = pd.read_csv(raw_data)
    raw_data.close()
    file.file.close()
    return {"filename": file.filename}


@router.get("/daily")
def daily_data(date: str):
    try:
        global data
        op = WeatherReport.daily_data(data, date)
        return DefaultResponse(message="Successfully found", status="success", data=op)
    except ValueError:
        return DefaultResponse(message="Due to Value Error")
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Finding failed due to server error")


@router.get("/weekly")
def weekly_data(start_date: str, end_date: str):
    try:
        global data
        op = WeatherReport.weekly_data(data, start_date, end_date)
        return DefaultResponse(message="Successfully found", status="success", data=op)
    except ValueError:
        return DefaultResponse(message="Due to Value Error")
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Finding failed due to server error")


@router.get("/monthly")
def monthly_data(year: int, month: int):
    try:
        global data
        op = WeatherReport.monthly_data(data, year, month)
        return DefaultResponse(message="Successfully found", status="success", data=op)
    except ValueError:
        return DefaultResponse(message="Due to Value Error")
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Finding failed due to server error")


@router.get("/email")
def get_email(sender: str, receiver: str, password: str):
    try:
        WeatherReport.send_file(sender, receiver, password)
        return DefaultResponse(message="Successfully found", status="success")
    except ValueError:
        return DefaultResponse(message="Due to Value Error")
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Finding failed due to server error")

