import smtplib
from typing import Optional

import pandas as pd
import ssl
from email.message import EmailMessage
from email.mime.multipart import MIMEMultipart

from openpyxl.utils.datetime import to_excel


class WeatherReport:

    @staticmethod
    def daily_data(df, date):
        try:

            df[['Date', 'Time']] = df['Formatted Date'].str.split(' ', n=1, expand=True)
            filtered_df = df[df['Date'] == date]
            condition = "daily"


            min_temp = filtered_df['Temperature (C)'].min(axis=0)
            max_temp = filtered_df['Temperature (C)'].max(axis=0)
            avg_temp = filtered_df['Temperature (C)'].mean(axis=0)


            min_at = filtered_df['Apparent Temperature (C)'].min(axis=0)
            max_at = filtered_df['Apparent Temperature (C)'].max(axis=0)
            avg_at = filtered_df['Apparent Temperature (C)'].mean(axis=0)


            min_hum = filtered_df['Humidity'].min(axis=0)
            max_hum = filtered_df['Humidity'].max(axis=0)
            avg_hum = filtered_df['Humidity'].mean(axis=0)


            min_ws = filtered_df['Wind Speed (km/h)'].min(axis=0)
            max_ws = filtered_df['Wind Speed (km/h)'].max(axis=0)
            avg_ws = filtered_df['Wind Speed (km/h)'].mean(axis=0)


            min_wb = filtered_df['Wind Bearing (degrees)'].min(axis=0)
            max_wb = filtered_df['Wind Bearing (degrees)'].max(axis=0)
            avg_wb = filtered_df['Wind Bearing (degrees)'].mean(axis=0)


            min_vis = filtered_df['Visibility (km)'].min(axis=0)
            max_vis = filtered_df['Visibility (km)'].max(axis=0)
            avg_vis = filtered_df['Visibility (km)'].mean(axis=0)


            min_pre = filtered_df['Pressure (millibars)'].min(axis=0)
            max_pre = filtered_df['Pressure (millibars)'].max(axis=0)
            avg_pre = filtered_df['Pressure (millibars)'].mean(axis=0)

            value_return = {"date": date,

                            "Minimum": {"Temperature": round(min_temp, 2), "Apparent Temperature": round(min_at, 2),
                                        "Humidity": round(min_hum, 2),
                                        "Wind Speed": round(min_ws, 2), "Wind Bearing": round(min_wb, 2),
                                        "Visibility": round(min_vis, 2),
                                        "Pressure": round(min_pre, 2)},

                            "Maximum": {"Temperature": round(max_temp, 2), "Apparent Temperature": round(max_at, 2),
                                        "Humidity": round(max_hum, 2),
                                        "Wind Speed": round(max_ws, 2), "Wind Bearing": round(max_wb, 2),
                                        "Visibility": round(max_vis, 2),
                                        "Pressure": round(max_pre, 2)},

                            "Average": {"Temperature": round(avg_temp, 2), "Apparent Temperature": round(avg_at, 2),
                                        "Humidity": round(avg_hum, 2),
                                        "Wind Speed": round(avg_ws, 2), "Wind Bearing": round(avg_wb, 2),
                                        "Visibility": round(avg_vis, 2),
                                        "Pressure": round(avg_pre, 2)}}
            new_data = value_return
            WeatherReport.get_excel(condition, value_return)
            return new_data
        except ValueError:
            raise ValueError
        except Exception as e:
            print(e, "Error Detected")

    @staticmethod
    def weekly_data(df, start_date, end_date):
        try:

            df[["date", "time"]] = df["Formatted Date"].str.split(" ", n=1, expand=True)
            df["date"] = pd.to_datetime(df["date"])
            start_date = pd.to_datetime(start_date)
            end_date = pd.to_datetime(end_date)
            filtered_df = df.loc[(df["date"] >= start_date) & (df["date"] <= end_date)]
            condition = "weekly"

            # Temperature
            min_temp = filtered_df['Temperature (C)'].min(axis=0)
            max_temp = filtered_df['Temperature (C)'].max(axis=0)
            avg_temp = filtered_df['Temperature (C)'].mean(axis=0)

            # Apparent Temperature
            min_at = filtered_df['Apparent Temperature (C)'].min(axis=0)
            max_at = filtered_df['Apparent Temperature (C)'].max(axis=0)
            avg_at = filtered_df['Apparent Temperature (C)'].mean(axis=0)

            # Humidity
            min_hum = filtered_df['Humidity'].min(axis=0)
            max_hum = filtered_df['Humidity'].max(axis=0)
            avg_hum = filtered_df['Humidity'].mean(axis=0)

            # Wind Speed
            min_ws = filtered_df['Wind Speed (km/h)'].min(axis=0)
            max_ws = filtered_df['Wind Speed (km/h)'].max(axis=0)
            avg_ws = filtered_df['Wind Speed (km/h)'].mean(axis=0)

            # Wind Bearing
            min_wb = filtered_df['Wind Bearing (degrees)'].min(axis=0)
            max_wb = filtered_df['Wind Bearing (degrees)'].max(axis=0)
            avg_wb = filtered_df['Wind Bearing (degrees)'].mean(axis=0)

            # Visibility
            min_vis = filtered_df['Visibility (km)'].min(axis=0)
            max_vis = filtered_df['Visibility (km)'].max(axis=0)
            avg_vis = filtered_df['Visibility (km)'].mean(axis=0)

            # Pressure
            min_pre = filtered_df['Pressure (millibars)'].min(axis=0)
            max_pre = filtered_df['Pressure (millibars)'].max(axis=0)
            avg_pre = filtered_df['Pressure (millibars)'].mean(axis=0)

            value_return = {"date": start_date,
                            "date": end_date,

                            "Minimum": {"Temperature": round(min_temp, 2), "Apparent Temperature": round(min_at, 2),
                                        "Humidity": round(min_hum, 2),
                                        "Wind Speed": round(min_ws, 2), "Wind Bearing": round(min_wb, 2),
                                        "Visibility": round(min_vis, 2),
                                        "Pressure": round(min_pre, 2)},

                            "Maximum": {"Temperature": round(max_temp, 2), "Apparent Temperature": round(max_at, 2),
                                        "Humidity": round(max_hum, 2),
                                        "Wind Speed": round(max_ws, 2), "Wind Bearing": round(max_wb, 2),
                                        "Visibility": round(max_vis, 2),
                                        "Pressure": round(max_pre, 2)},

                            "Average": {"Temperature": round(avg_temp, 2), "Apparent Temperature": round(avg_at, 2),
                                        "Humidity": round(avg_hum, 2),
                                        "Wind Speed": round(avg_ws, 2), "Wind Bearing": round(avg_wb, 2),
                                        "Visibility": round(avg_vis, 2),
                                        "Pressure": round(avg_pre, 2)}}

            new_data = value_return
            WeatherReport.get_excel(condition, value_return)
            return new_data
        except ValueError:
            raise ValueError
        except Exception as e:
            print(e, "Error Detected")

    @staticmethod
    def monthly_data(df, year, month):
        try:

            df[["date", "time"]] = df["Formatted Date"].str.split(" ", n=1, expand=True)
            df["date"] = pd.to_datetime(df["date"])
            df["date"] = pd.to_datetime(df["date"])
            filtered_df = df.loc[(df["date"].dt.year == year) & (df["date"].dt.month == month)]
            filtered_df = filtered_df.drop(columns=["time"])
            condition = "monthly"


            # Temperature
            min_temp = filtered_df['Temperature (C)'].min(axis=0)
            max_temp = filtered_df['Temperature (C)'].max(axis=0)
            avg_temp = filtered_df['Temperature (C)'].mean(axis=0)

            # Apparent Temperature
            min_at = filtered_df['Apparent Temperature (C)'].min(axis=0)
            max_at = filtered_df['Apparent Temperature (C)'].max(axis=0)
            avg_at = filtered_df['Apparent Temperature (C)'].mean(axis=0)

            # Humidity
            min_hum = filtered_df['Humidity'].min(axis=0)
            max_hum = filtered_df['Humidity'].max(axis=0)
            avg_hum = filtered_df['Humidity'].mean(axis=0)

            # Wind Speed
            min_ws = filtered_df['Wind Speed (km/h)'].min(axis=0)
            max_ws = filtered_df['Wind Speed (km/h)'].max(axis=0)
            avg_ws = filtered_df['Wind Speed (km/h)'].mean(axis=0)

            # Wind Bearing
            min_wb = filtered_df['Wind Bearing (degrees)'].min(axis=0)
            max_wb = filtered_df['Wind Bearing (degrees)'].max(axis=0)
            avg_wb = filtered_df['Wind Bearing (degrees)'].mean(axis=0)

            # Visibility
            min_vis = filtered_df['Visibility (km)'].min(axis=0)
            max_vis = filtered_df['Visibility (km)'].max(axis=0)
            avg_vis = filtered_df['Visibility (km)'].mean(axis=0)

            # Pressure
            min_pre = filtered_df['Pressure (millibars)'].min(axis=0)
            max_pre = filtered_df['Pressure (millibars)'].max(axis=0)
            avg_pre = filtered_df['Pressure (millibars)'].mean(axis=0)

            value_return = {"month": month,
                            "year": year,

                            "Minimum": {"Temperature": round(min_temp, 2), "Apparent Temperature": round( min_at, 2), "Humidity": round(min_hum, 2),
                                        "Wind Speed": round(min_ws, 2), "Wind Bearing": round(min_wb, 2), "Visibility": round (min_vis, 2),
                                        "Pressure": round(min_pre, 2)},

                            "Maximum": {"Temperature": round(max_temp, 2), "Apparent Temperature": round(max_at, 2), "Humidity" : round(max_hum, 2),
                                        "Wind Speed": round(max_ws, 2), "Wind Bearing": round(max_wb, 2), "Visibility": round (max_vis, 2),
                                        "Pressure": round(max_pre, 2)},

                            "Average": {"Temperature": round(avg_temp, 2), "Apparent Temperature": round(avg_at, 2),  "Humidity": round(avg_hum, 2),
                                        "Wind Speed": round(avg_ws, 2), "Wind Bearing": round(avg_wb, 2), "Visibility": round(avg_vis, 2),
                                        "Pressure": round(avg_pre, 2)}}
            new_data = value_return
            WeatherReport.get_excel(condition, value_return)
            return new_data
        except ValueError:
            raise ValueError
        except Exception as e:
            print(e, "Error Detected")

    @staticmethod
    def get_excel(condition, value_return):
        try:
            df = pd.DataFrame(value_return)
            df.to_excel(f"Weather Report_{condition}.xlsx", index=True)
            return "Dictionary converted into excel"
        except ValueError:
            raise ValueError
        except Exception as e:
            print(e, "Excel Error Detected")

    @staticmethod
    def send_file(sender, receiver, sender_password):
        try:
            files = ['Weather Report_daily.xlsx', 'Weather Report_weekly.xlsx', 'Weather Report_monthly.xlsx']
            msg = EmailMessage()
            msg['From'] = sender
            msg['To'] = receiver
            msg['Subject'] = "weather report"
            context = ssl.create_default_context()

            for file_read in files:
                with open(file_read, "rb") as file:
                    file_data = file.read()
                    file_name = file.name
                    print(file_name)
                    msg.add_attachment(file_data, maintype="application", subtype="xlsx", filename=file_name)
            with smtplib.SMTP_SSL('smtp.gmail.com', 465, context=context) as smtp:
                smtp.login(sender, sender_password)
                smtp.sendmail(sender, receiver, msg.as_string())
        except ValueError:
            raise ValueError
        except Exception as e:
            print(e, "Excel Error Detected")



