from sqlalchemy import create_engine,  Column, Integer, DateTime, select
from sqlalchemy.orm import sessionmaker, declarative_base
from datetime import timedelta, datetime
import pandas as pd

engine = create_engine('postgresql://interns:interns%40123@192.168.0.220:5432/internsb2')

Session = sessionmaker(bind=engine)

Base = declarative_base()


class MyData(Base):
    __tablename__ = 'my_data'
    id = Column("id", Integer, primary_key=True)
    start_time = Column("start_time", DateTime(timezone=True))
    buffer_time = Column("buffer_time", Integer)
    end_time = Column("end_time", DateTime(timezone=True))


Base.metadata.create_all(engine)

data = [
    {'start_time': datetime(2023, 4, 1, 10, 0, 0), 'buffer_time': 30},
    {'start_time': datetime(2023, 4, 2, 14, 0, 0), 'buffer_time': 45},
    {'start_time': datetime(2023, 4, 3, 9, 0, 0), 'buffer_time': 15},
]

with Session() as session:
    for row in data:
        my_data = MyData(start_time=row['start_time'], buffer_time=row['buffer_time'])
        session.add(my_data)
    session.commit()

with Session() as session:
    query = select([MyData.id, MyData.start_time, MyData.buffer_time])
    result = session.execute(query)
    rows = result.fetchall()

    for row in rows:
        id_, start_time, buffer_time = row
        end_time = start_time + timedelta(minutes=buffer_time)
        session.query(MyData).filter(MyData.id == id_).update({"end_time": end_time})

    session.commit()

with Session() as session:
    query = select([MyData.start_time, MyData.end_time])
    result = session.execute(query)
    df = pd.DataFrame(result.fetchall(), columns=["start_time", "end_time"])

df['start_time'] = pd.to_datetime(df['start_time'], utc=True).dt.strftime('%Y-%m-%d %H:%M:%S')
df['end_time'] = pd.to_datetime(df['end_time'], utc=True).dt.strftime('%Y-%m-%d %H:%M:%S')

print(df.to_string(index=False))







