from script.core.schema.model import User, Subordinates, Base
from script.utils.sqlite_connection import session, engine


class Utils:
    @staticmethod
    def create_info(id: int, name: str, city: str):
        new_employee = User(id=id, name=name, city=city)
        session.add(new_employee)
        session.commit()
        return {"message": "User info created successfully"}

    @staticmethod
    def insert_into_subordinate(id, user_id, subordinate_ids, subordinate_name):
        try:
            subordinates = Subordinates(id=id, user_id=user_id, subordinate_name=subordinate_name,
                                        subordinate_ids=",".join(str(i) for i in subordinate_ids))
            session.add(subordinates)
            session.commit()
        except Exception as e:
            print(e)

    @staticmethod
    def find_query(user_id):
        user_data = session.query(User).filter(User.id == user_id).all()
        subordinates_data = session.query(Subordinates).filter(Subordinates.user_id == user_id).all()
        list_ = []
        for data in user_data:
            list_.append({"id": data.id, "name": data.name, "city": data.city})
        for data in subordinates_data:
            list_.append({"id": data.id, "user_id": data.user_id, "subordinate_ids": data.subordinate_ids,
                          "subordinate_name": data.subordinate_name})
            session.close()
            return list_
        return {"message": "successfully founded"}

