import json
import logging
from fastapi import APIRouter, UploadFile, File
from script.constants import APIEndpoints
from script.core.handlers.emp_info import Userdetails
from script.core.schema.response import DefaultResponse


user_details = Userdetails()

router = APIRouter(prefix=APIEndpoints.employee_base)
handler = Userdetails()

data = {}


@router.post("/upload")
async def upload_file(file: UploadFile = File()):
    global data
    try:
        contents = file.file.read()
        data = json.loads(contents)
    except Exception as e:
        print(e, "uploading failed")


@router.post(APIEndpoints.insert)
async def insert_item():
    try:
        handler.create_user(data)
        return DefaultResponse(message="Successfully Inserted", status="success")
    except ValueError:
        return DefaultResponse(message="Due to value error")
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Insertion Failed due to server error")


@router.get(APIEndpoints.list)
async def list_item():
    try:
        data = handler.find_data()
        return DefaultResponse(message="Successfully Found", status="success", data=data)
    except ValueError:
        return DefaultResponse(message="Due to value error")
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Finding Failed due to server error")
