import os
import sqlite3
from configparser import ConfigParser

config = ConfigParser()
config.read('conf/application.conf')


class Service:
    port = config.getint('service', 'port')
    host = config.get('service', 'host')


class Sqlite:
    db_uri = os.environ.get('DB_URI')


def create_sqlite_connection():
    conn = sqlite3.connect("internsb2.db", check_same_thread=False)
    return conn
