import numpy as np
import pandas as pd
from sqlalchemy import MetaData
from sqlalchemy.testing.schema import Table
from script.constants import Place
from script.utils.sqlite_connection import engine
from script.utils.sqlite_utils import Utils

my_data = Utils


class Userdetails:
    @staticmethod
    def create_user(data):

        try:

            employee_df = pd.DataFrame(data["employees"])
            employee_df["city"] = np.random.choice(Place.cities, size=len(employee_df))
            for _, employee in employee_df.iterrows():
                Utils.create_info(id=employee["id"], name=employee["name"], city=employee["city"])
                subordinates = employee_df.loc[employee_df["id"].isin(employee["subordinates"]), "name"].tolist()
                subordinate_name = ", ".join(subordinates)
                id = employee['id']
                user_id = employee['id']
                Utils.insert_into_subordinate(id, user_id, employee["subordinates"], subordinate_name)
            return {"message": "User info created successfully"}
        except Exception as e:
            print(e, "Error Detected in inserting")

    @staticmethod
    def find_data():
        try:
            conn = engine.connect()
            metadata = MetaData()
            user_info = Table('user_info', metadata, autoload=True, autoload_with=engine)
            subordinates_info = Table('subordinates_info', metadata, autoload=True, autoload_with=engine)
            user_info_columns = [col.name for col in user_info.columns]
            subordinate_columns = [col.name for col in subordinates_info.columns]
            user_info_query = user_info.select()
            user_info_rows = conn.execute(user_info_query).fetchall()
            user_info_body = [{user_info_columns[i]: row[i] for i in range(len(user_info_columns))} for row in
                              user_info_rows]
            subordinate_query = subordinates_info.select()
            subordinate_rows = conn.execute(subordinate_query).fetchall()
            subordinate_body = [{subordinate_columns[i]: row[i] for i in range(len(subordinate_columns))} for row in
                                subordinate_rows]
            conn.close()
            return {"header": user_info_columns, "body": user_info_body, "subordinate_header": subordinate_columns,
                    "subordinate_body": subordinate_body}
        except Exception as e:
            print(e, "Error detected in finding employee data")