import sqlite3

from script.core.schema.model import Employee
from script.utils.sqlite_connection import create_sqlite_connection

conn = create_sqlite_connection()
cur = conn.cursor()

Employee.create_tables()


class Utils:
    @staticmethod
    def create_info(id: int, name: str, city: str):
        conn = sqlite3.connect("internsb2.db")
        cursor = conn.cursor()
        cursor.execute("INSERT INTO user_info (id, name, city) VALUES (?, ?,?)", (id, name, city))
        conn.commit()
        return {"message": "User info created successfully"}

    @staticmethod
    def insert_into_subordinate(id, user_id, subordinate_ids, subordinate_name):
        try:
            create_sqlite_connection()
            cursor = conn.cursor()
            cursor.execute(
                "INSERT INTO subordinates_info (id, user_id, subordinate_name, subordinate_ids) VALUES (?, ?, ?, ?)",
                (id, user_id, subordinate_name, ",".join(str(i) for i in subordinate_ids)))
            conn.commit()
            conn.close()
            print("Subordinate IDs:", ", ".join(str(i) for i in subordinate_ids))
        except Exception as e:
            print(e)

    @staticmethod
    def find_query(user_id):
        cursor = conn.cursor()
        cursor.execute("SELECT id, name, city FROM Employee WHERE id=?", (user_id,))
        user_data = cursor.fetchall()
        cursor.execute("SELECT id, user_id, subordinate_ids, subordinate_name FROM Subordinates WHERE user_id=?",
                       (user_id,))
        subordinates_data = cursor.fetchall()
        list_ = []
        for data in user_data:
            list_.append({"id": data[0], "name": data[1], "city": data[2]})
        for data in subordinates_data:
            list_.append({"id": data[0], "user_id": data[1], "subordinate_ids": data[2], "subordinate_name": data[3]})
            conn.close()
            return list_
        return {"message": "successfully founded"}

