import logging

from fastapi import APIRouter

from script.constants import APIEndpoints
from script.core.handlers.sqlite import Userdetails
from script.core.schema.response import DefaultResponse

user_details = Userdetails()

router = APIRouter(prefix=APIEndpoints.employee_base)
handler = Userdetails()


@router.post(APIEndpoints.insert)
def insert_item():
    try:
        handler.create_user()
        return DefaultResponse(message="Successfully Inserted", status="success")
    except ValueError:
        return DefaultResponse(message="Due to value error")
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Insertion Failed due to server error")

@router.get(APIEndpoints.find)
async def find_item():
    try:
        data = handler.find_data()
        return DefaultResponse(message="Successfully Found", status="success", data=data)
    except ValueError:
        return DefaultResponse(message="Due to value error")
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Finding Failed due to server error")


