import json
import random
import sqlite3
from script.utils.sqlite_utils import Utils
from script.utils.sqlite_connection import create_sqlite_connection

my_data = Utils

with open("employee_details.json") as f:
    data = json.load(f)


class Userdetails:
    @staticmethod
    def create_user():
        try:
            cities = ['New York', 'Los Angeles', 'Chicago', 'Houston', 'Phoenix', 'Philadelphia', 'San Antonio',
                      'San Diego', 'Dallas', 'San Jose', 'Austin', 'Jacksonville', 'Fort Worth', 'Columbus',
                      'San Francisco', 'Charlotte', 'Indianapolis', 'Seattle', 'Denver', 'Washington']
            for employee in data["employees"]:
                employee["city"] = random.choice(cities)
                Utils.create_info(id=employee["id"], name=employee["name"], city=employee["city"])
                subordinates = []
                for subordinate_id in employee["subordinates"]:
                    subordinate = next(
                        (subordinate for subordinate in data["employees"] if subordinate["id"] == subordinate_id), None)
                    if subordinate is not None:
                        subordinates.append(subordinate["name"])
                subordinate_name = ", ".join(subordinates)
                id = employee['id']
                user_id = employee['id']
                Utils.insert_into_subordinate(id, user_id, employee["subordinates"], subordinate_name)
            return {"message": "User info created successfully"}
        except Exception as e:
            print(e, "Error Detected in inserting")

    @staticmethod
    def find_data():
        try:
            conn = create_sqlite_connection()
            cursor = conn.cursor()
            cursor.execute("SELECT * FROM user_info")
            columns = cursor.description
            header = [{"label": col[0].replace("_", " ").title(), "value": col[0]} for col in columns]
            cursor.execute("SELECT * FROM user_info")
            rows = cursor.fetchall()
            user_info = [{"id": row[0], "name": row[1], "city": row[2]} for row in rows]

            cursor.execute("SELECT * FROM subordinates_info")
            columns = cursor.description
            subordinate_header = [{"label": col[0].replace("_", " ").title(), "value": col[0]} for col in columns]
            cursor.execute("SELECT * FROM subordinates_info")
            rows = cursor.fetchall()
            subordinate_info = [{"id": row[0], "user_id": row[1], "subordinate_ids": row[2], "subordinate_name": row[3]}
                                for row in rows]

            conn.close()

            return {"header": header, "body": user_info, "subordinate_header": subordinate_header,
                    "subordinate_body": subordinate_info}

        except Exception as e:
            print(e, "Error detected in finding employee data")
