from sqlalchemy import Column, Integer, String, ForeignKey
from sqlalchemy.ext.declarative import declarative_base

Base = declarative_base()



class User(Base):
    __tablename__ = 'user_info'
    id = Column(Integer, primary_key=True)
    name = Column(String)
    city = Column(String)


class Subordinates(Base):
    __tablename__ = 'subordinates_info'
    id = Column(Integer, primary_key=True, autoincrement=True)
    user_id = Column(Integer, ForeignKey('user_info.id'))
    subordinate_ids = Column(String, nullable=True)
    subordinate_name = Column(String, nullable=False)


