
from script.core.schema.postgresql import Model
from script.utils.postgresql_connection import session


class Utils:
    @staticmethod
    def insert_query(request_data):
        employee_data = Model(emp_id=request_data.emp_id, emp_name=request_data.emp_name,
                              emp_department=request_data.emp_department,
                              emp_sal=request_data.emp_sal)
        return employee_data

    @staticmethod
    def find_query(emp_id):
        employee_data = session.query(Model).all()
        list_ = []
        for data in employee_data:
            list_.append({"emp_id": data.emp_id, "emp_name": data.emp_name,
                          "emp_department": data.emp_department,
                          "emp_sal": data.emp_sal})
        return list_
        return employee_data

    @staticmethod
    def update_query(request_data, emp_id):
        get_update = {key: value for key, value in request_data if
                      value is not None and value != 'string' and value != 0}
        update_data = session.query(Model).filter(
            Model.emp_id == emp_id).update(get_update)
        return update_data

    @staticmethod
    def delete_query(emp_id):
        data = session.query(Model).filter_by(emp_id=emp_id).first()
        return data
