from typing import Optional

from pydantic import BaseModel
from sqlalchemy import Column, Integer, String
from sqlalchemy.orm import declarative_base

from script.utils.postgresql_connection import engine


# define a model for Item
class Employee(BaseModel):
    emp_id: int
    emp_name: Optional[str]
    emp_department: Optional[str]
    emp_sal: Optional[int]


Base = declarative_base()


class Model(Base):
    __tablename__ = 'employee'
    emp_id = Column('emp_id', Integer, primary_key=True, index=True)
    emp_name = Column('emp_name', String(30))
    emp_department = Column('emp_dept', String(100))
    emp_sal = Column('salary', Integer)

Base.metadata.create_all(engine)