from sqlalchemy import MetaData
from sqlalchemy import Column, Integer, String, MetaData, text
from script.core.schema.postgresql import Employee, Model
from script.utils.postgresql_connection import session
from script.utils.postgresql_utils import Utils


my_utils = Utils()

class EmployeeData:
    @staticmethod
    def insert_data(request_data):
        try:
            temp = my_utils.insert_query(request_data)
            session.add(temp)
            session.commit()
            return temp
        except Exception as e:
            print(e, "Error Detected in inserting")


    @staticmethod
    def find_data(emp_id):
        try:
            header = [{"label": col.replace("_", " ").title(), "value": col} for col in Model.__table__.columns.keys()]

            employee_data = session.query(Model).all()

            return {"header": header, "body": employee_data}
        except Exception as e:
            print(e, "Error Detected in finding employee data")

    @staticmethod
    def update_data(request_data, emp_id):
        try:
            temp = my_utils.update_query(request_data, emp_id)
            session.commit()
            return temp
        except Exception as e:
            print(e, "Error detected in updating")

    @staticmethod
    def delete_data(emp_id):
        try:
            temp=my_utils.delete_query(emp_id)
            session.delete(temp)
            session.commit()
            return temp
        except Exception as e:
            print(e, "Error detected in deleting")

