import logging
from fastapi import APIRouter
from script.constants import APIEndpoints
from script.core.handlers.postgresql import EmployeeData
from script.core.schema.postgresql import Employee
from script.core.schema.response import DefaultResponse

router = APIRouter(prefix=APIEndpoints.employee_base)
handler = EmployeeData()


@router.delete(APIEndpoints.delete)
async def delete_item(emp_id: int):

    try:
        handler.delete_data(emp_id)
        return DefaultResponse(message="Successfully deleted", status="success")
    except ValueError:
        return DefaultResponse(message="Due to Value Error")
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Deletion failed due to server error")


@router.post(APIEndpoints.update)
async def update_item(emp_id: int, request_data: Employee):
    try:
        handler.update_data( request_data, emp_id)
        return DefaultResponse(message="Successfully Updated", status="success")
    except ValueError:
        return DefaultResponse(message="Due to value error")
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Updation Failed due to server error")


@router.get(APIEndpoints.find)
async def find_item(emp_id:int):
    try:
        data = handler.find_data(emp_id)
        return DefaultResponse(message="Successfully Found", status="success", data=data)
    except ValueError:
        return DefaultResponse(message="Due to value error")
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Finding Failed due to server error")


@router.post(APIEndpoints.insert)
def insert_item(request_data: Employee):
    try:
        op = handler.insert_data(request_data)
        return DefaultResponse(message="Successfully Found", status="success", op=op)
    except ValueError:
        return DefaultResponse(message="Due to value error")
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Finding Failed due to server error")
