from sqlalchemy import MetaData
from sqlalchemy import Column, Integer, String, MetaData, text
from script.core.schema.postgresql import Employee, Model
from script.utils.postgresql_connection import session



class EmployeeData:
    @staticmethod
    def insert_data(request_data):
        try:
            employee_data = Model(emp_id=request_data.emp_id, emp_name=request_data.emp_name,
                                  emp_department=request_data.emp_department,
                                  emp_sal=request_data.emp_sal)
            session.add(employee_data)
            session.commit()
            return employee_data
        except Exception as e:
            print(e, "Error Detected in inserting")

    @staticmethod
    def find_data(emp_id):
        try:
            employee_data= session.query(Model).all()
            list_ = []
            for data in employee_data:
                list_.append({"emp_id": data.emp_id, "emp_name": data.emp_name,
                              "emp_department": data.emp_department,
                              "emp_sal": data.emp_sal})
            return list_
            return employee_data
        except Exception as e:
            print(e, "Error Detected in finding employee data")

    @staticmethod
    def update_data(request_data, emp_id):
        try:
            get_update = {key: value for key, value in request_data if
                          value is not None and value != 'string' and value != 0}
            update_data = session.query(Model).filter(
                text(str(f"emp_id={emp_id}"))
            ).update(
                get_update
            )
            session.commit()
            print(update_data)
            return update_data
        except Exception as e:
            print(e, "Error detected in updating")

    @staticmethod
    def delete_data(emp_id):
        try:
            data = session.query(Model).filter_by(emp_id=emp_id).first()
            session.delete(data)
            session.commit()
            return data
        except Exception as e:
            print(e, "Error detected in deleting")





