import os
from dotenv import load_dotenv
from configparser import SafeConfigParser


config = SafeConfigParser()
config.read('conf/application.conf')
load_dotenv()


class Service:
    host = config.get("MONGO_SERVICE", "broker_host")
    port = int(config.get("MONGO_SERVICE", "broker_port"))


class Mongo:
    mongo_uri: str = os.environ.get("get_mongo")

