from typing import Dict, List, Optional

from pymongo import MongoClient


import logging


class MongoConnect:
    def __init__(self, uri):
        try:
            self.uri = uri
            self.client = MongoClient(self.uri, connect=False)
        except Exception as e:
            logging.error(f"Exception in connection {(str(e))}")
            raise e


class MongoCollectionBaseClass:
    def __init__(self, mongo_client, database, collection):
        self.client = mongo_client
        self.database = database
        self.collection = collection


def insert_one(self, data: Dict):
    try:
        database_name = self.database
        collection_name = self.collection
        db = self.client[database_name]
        collection = db[collection_name]
        response = collection.insert_one(data)
        return response.inserted_id
    except Exception as e:
        logging.error(f"Error in inserting the data {str(e)}")
        raise e

def find_one(self, query: Dict, filter_dict: Optional[Dict] = None):
    try:
        database_name = self.database
        collection_name = self.collection
        if filter_dict is None:
            filter_dict = {"_id": 0}
            db = self.client[database_name]
            collection = db[collection_name]
            response = collection.find_one(query, filter_dict)
        return response
    except Exception as e:
        logging.error(f"Failed to fetch {str(e)}")
        raise e


def update_one(self, query: Dict, data: Dict, upsert: bool = False, ):
    try:
        database_name = self.database
        collection_name = self.collection
        db = self.client[database_name]
        collection = db[collection_name]
        response = collection.update_one(query, {"$set": data}, upsert=upsert)
        return response.modified_count
    except Exception as e:
        logging.error(f"Failed to update one doc {str(e)}")
        raise e


def delete_one(self, query: Dict):
    try:
        database_name = self.database
        collection_name = self.collection
        db = self.client[database_name]
        collection = db[collection_name]
        response = collection.delete_one(query)
        return response.deleted_count
    except Exception as e:
        logging.error(f"Failed to delete {str(e)}")
        raise e
