import logging

from fastapi.routing import APIRouter

from script.constants import APIEndpoints
from script.core.handlers.employee import EmployeeData
from script.core.schema.response import DefaultResponse

router = APIRouter(prefix=APIEndpoints.employee_base)
handler = EmployeeData()


@router.post(APIEndpoints.delete)
async def delete_item(emp_id: int):
    """This API deletes an item"""
    try:
        handler.delete_data(emp_id,int)
        return DefaultResponse(message="Successfully deleted", status="success")
    except ValueError:
        return DefaultResponse(message="Due to Value Error")
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Deletion failed due to server error")


@router.post(APIEndpoints.update)
async def update_item(emp_id: int):
    try:
        handler.update_data(emp_id,int)
        return DefaultResponse(message="Successfully Updated", status="success")
    except ValueError:
        return DefaultResponse(message="Due to value error")
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Updation Failed due to server error")


@router.get(APIEndpoints.find)
async def find_item(emp_id: int):
    try:
        handler.find_data(emp_id,int)
        return DefaultResponse(message="Successfully Found", status="success")
    except ValueError:
        return DefaultResponse(message="Due to value error")
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Finding Failed due to server error")

@router.get(APIEndpoints.insert)
async def insert_item(emp_id: int):
    try:
        handler.insert_data(emp_id,int)
        return DefaultResponse(message="Successfully Found", status="success")
    except ValueError:
        return DefaultResponse(message="Due to value error")
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Finding Failed due to server error")
