from script.core.db.mongo.interns2023 import mongo_client
from script.core.db.mongo.interns2023.employee import EmployeeDetails
from script.core.schema.employee import Employee


class EmployeeData:

    def __init__(self):
        self.employee_col = EmployeeDetails(mongo_client=mongo_client)

    def delete_data(self, emp_id):
        try:
            self.employee_col.delete_one(query={"emp_id": emp_id})
        except ValueError:
            raise ValueError("ID")
        except Exception as e:
            print(e, "Error Detected in Deletion")

    def update_data(self, request_data: Employee):
        try:
            d = {"emp_id": request_data.emp_id,
                 "emp_name": request_data.emp_name,
                 "emp_department": request_data.emp_department,
                 "emp_sal": request_data.emp_sal}
            self.employee_col.update_one(query={"emp_id": request_data.emp_id}, data=d)
        except Exception as e:
            print(e, "Error Detected in Updation")

    def find_data(self, emp_id):
        try:
            data = self.employee_col.find_one(query={"emp_id": emp_id})
            return data
        except Exception as e:
            print(e, "Error Detected in Finding")

    def insert_data(self, request_data: Employee):
        try:
            d = {"emp_id": request_data.emp_id,
                 "emp_name": request_data.emp_name,
                 "emp_department": request_data.emp_department,
                 "emp_sal": request_data.emp_sal}
            self.employee_col.insert_one(d)
        except Exception as e:
            print(e, "Error Detected in inserting")

