resource "aws_iam_role_policy" "policy_ec2"{
          name = "policy_ec2"
          role = aws_iam_role.role_ec2.id
          policy = jsonencode({
          Version = "2012-10-17"
          Statement = [{
                    "Sid": "Statement1",
                    "Effect": "Allow",
                    Action = [
                          "ec2-instance-connect:SendSerialConsoleSSHPublicKey",
                          "ec2-instance-connect:SendSSHPublicKey",
                          "autoscaling:ExecutePolicy",
                          "s3:CreateBucket",
                          "s3:DeleteBucket"
                    ]
                    "Resource": ["*" ]
          }]
          })
}

resource "aws_iam_role" "role_ec2" {
        name = role_ec2
        assume_role_policy = jsonencode({
        Version = "2012-10-17"
        Statement = [{
                "Effect": "Allow"
                "Principal": {
                          "Service": "ec2.amazonaws.com"
                }
                "Action": "sts:AssumeRole"
        }]
        })
}