import os
import platform
import sys
from pathlib import Path

import torch

FILE = Path(__file__).resolve()
ROOT = FILE.parents[0]  # YOLOv5 root directory
if str(ROOT) not in sys.path:
    sys.path.append(str(ROOT))  # add ROOT to PATH
ROOT = Path(os.path.relpath(ROOT, Path.cwd()))  # relative

from models.common import DetectMultiBackend
from utils.dataloaders import IMG_FORMATS, VID_FORMATS, LoadImages, LoadScreenshots, LoadStreams
from utils.general import (LOGGER, Profile, check_file, check_img_size, check_imshow, check_requirements, colorstr, cv2,
                           increment_path, non_max_suppression, print_args, scale_boxes, strip_optimizer, xyxy2xywh)
from utils.plots import Annotator, colors, save_one_box
from utils.torch_utils import select_device, smart_inference_mode




def load_model(weights, data='data/coco128.yaml', device='', half=False, dnn=False):
    # Load model
    print("loading....")
    device = select_device(device)
    model = DetectMultiBackend(weights, device=device, dnn=dnn, data=data, fp16=half)
    print("finish....")
    return  model


@smart_inference_mode()
def run(model1, # model path or triton URL
        source,  # file/dir/URL/glob/screen/0(webcam)
        data=ROOT / 'data/coco128.yaml',  # dataset.yaml path
        imgsz=(640, 640),  # inference size (height, width)
        conf_thres=0.2,  # confidence threshold
        iou_thres=0.15,  # NMS IOU threshold
        max_det=1000,  # maximum detections per image
        device='',  # cuda device, i.e. 0 or 0,1,2,3 or cpu
        view_img=False,  # show results
        save_txt=False,  # save results to *.txt
        save_conf=False,  # save confidences in --save-txt labels
        save_crop=False,  # save cropped prediction boxes
        nosave=False,  # do not save images/videos
        classes=None,  # filter by class: --class 0, or --class 0 2 3
        agnostic_nms=False,  # class-agnostic NMS
        augment=False,  # augmented inference
        visualize=False,  # visualize features
        update=False,  # update all models
        project=ROOT / 'runs/detect',  # save results to project/name
        name='exp',  # save results to project/name
        exist_ok=False,  # existing project/name ok, do not increment
        line_thickness=3,  # bounding box thickness (pixels)
        hide_labels=False,  # hide labels
        hide_conf=False,  # hide confidences
        half=False,  # use FP16 half-precision inference
        dnn=False,  # use OpenCV DNN for ONNX inference
        vid_stride=1,  # video frame-rate stride
):
    class_list = {0:"person", 1:"Safety helmet", 2:"Hand gloves", 3:"coverall suit", 4:"Air Breathing Mask"}
    # source = str(source)
    # save_img = not nosave and not source.endswith('.txt')  # save inference images
    # is_file = Path(source).suffix[1:] in (IMG_FORMATS + VID_FORMATS)
    # is_url = source.lower().startswith(('rtsp://', 'rtmp://', 'http://', 'https://'))
    # webcam = source.isnumeric() or source.endswith('.txt') or (is_url and not is_file)
    # screenshot = source.lower().startswith('screen')
    # if is_url and is_file:
    #     source = check_file(source)  # download
    #
    # # Directories
    # save_dir = increment_path(Path(project) / name, exist_ok=exist_ok)  # increment run
    # (save_dir / 'labels' if save_txt else save_dir).mkdir(parents=True, exist_ok=True)  # make dir

    # Load model
    model = model1
    stride, names, pt = model.stride, model.names, model.pt
    imgsz = check_img_size(imgsz, s=stride)  # check image size

    # Dataloader
    bs = 1  # batch_size
    # if webcam:
    #     view_img = check_imshow(warn=True)
    #     dataset = LoadStreams(source, img_size=imgsz, stride=stride, auto=pt, vid_stride=vid_stride)
    #     bs = len(dataset)
    # elif screenshot:
    #     dataset = LoadScreenshots(source, img_size=imgsz, stride=stride, auto=pt)
    # else:
    loading_image = LoadImages(source, img_size=imgsz, stride=stride, auto=pt, vid_stride=vid_stride)
    image, im, im0 = loading_image.load_image()

    # print("dataset is : ")
    # print(dataset)
    vid_path, vid_writer = [None] * bs, [None] * bs

    # Run inference
    model.warmup(imgsz=(1 if pt or model.triton else bs, 3, *imgsz))  # warmup
    seen, windows, dt = 0, [], (Profile(), Profile(), Profile())
    # path, im, im0s, s = dataset[0]
    # for path, im, im0s, s in dataset:
    # for i in range(1):
    with dt[0]:
        im = torch.from_numpy(im).to(model.device)
        im = im.half() if model.fp16 else im.float()  # uint8 to fp16/32
        im /= 255  # 0 - 255 to 0.0 - 1.0
        if len(im.shape) == 3:
            im = im[None]  # expand for batch dim

    # Inference
    with dt[1]:
        # visualize = increment_path(save_dir / Path(path).stem, mkdir=True) if visualize else False
        pred = model(im, augment=augment, visualize=visualize)

    # NMS
    with dt[2]:
        pred = non_max_suppression(pred, conf_thres, iou_thres, classes, agnostic_nms, max_det=max_det)

    # Second-stage classifier (optional)
    # pred = utils.general.apply_classifier(pred, classifier_model, im, im0s)

    # Process predictions
    for i, det in enumerate(pred):  # per image
        # seen += 1
        # if webcam:  # batch_size >= 1
        #     p, im0, frame = path[i], im0s[i].copy(), dataset.count
        #     s += f'{i}: '
        # else:
        # p, im0, frame = path, im0s.copy(), getattr(dataset, 'frame', 0)

        # p = Path(p)  # to Path
        # save_path = str(save_dir / p.name)  # im.jpg
        # txt_path = str(save_dir / 'labels' / p.stem) + ('' if dataset.mode == 'image' else f'_{frame}')  # im.txt
        # s += '%gx%g ' % im.shape[2:]  # print string
        # gn = torch.tensor(im0.shape)[[1, 0, 1, 0]]  # normalization gain whwh
        # imc = im0.copy() if save_crop else im0  # for save_crop
        # annotator = Annotator(im0, line_width=line_thickness, example=str(names))

        if len(det):
            # Rescale boxes from img_size to im0 size
            det[:, :4] = scale_boxes(im.shape[2:], det[:, :4], im0.shape).round()

            # # Print results
            # for c in det[:, 5].unique():
            #     n = (det[:, 5] == c).sum()  # detections per class
            #     s += f"{n} {names[int(c)]}{'s' * (n > 1)}, "  # add to string

            # Write results
        collect_data = []
        for *xyxy, conf, cls in reversed(det):
            x1 = int(xyxy[0])
            y1 = int(xyxy[1])
            x2 = int(xyxy[2])
            y2 = int(xyxy[3])

            p1 = int((x1 + x2) / 2)
            p2 = int((y1 + y2) / 2)
            radius = 1
            # cv2.rectangle(im0, (x2, y2),(x1, y1), [124, 254, 0])
            collect_data.append({"class":class_list[int(cls)], "points":[x1, y1, x2, y2],"centroid": [p1, p2]})
        # print(collect_data)
    # cv2.imshow("out222", cv2.resize(source, (900, 600)))
    # cv2.waitKey(1)


            # if save_txt:  # Write to file
            #     xywh = (xyxy2xywh(torch.tensor(xyxy).view(1, 4)) / gn).view(-1).tolist()  # normalized xywh
            #     line = (cls, *xywh, conf) if save_conf else (cls, *xywh)  # label format
                # with open(f'{txt_path}.txt', 'a') as f:
                #     f.write(('%g ' * len(line)).rstrip() % line + '\n')

            # if save_img or save_crop or view_img:  # Add bbox to image
            #     c = int(cls)  # integer class
            #     cv2.rectangle(imc, (x1, y1), (x2, y2), [25, 25, 255])
            #
            # if save_crop:
            #     save_one_box(xyxy, imc, file=save_dir / 'crops' / names[c] / f'{p.stem}.jpg', BGR=True)
            #
    # Stream results
    # im0 = annotator.result()
    # if view_img:
    #     if platform.system() == 'Linux' and p not in windows:
    #         windows.append(p)
    #         cv2.namedWindow(str(p), cv2.WINDOW_NORMAL | cv2.WINDOW_KEEPRATIO)  # allow window resize (Linux)
    #         cv2.resizeWindow(str(p), im0.shape[1], im0.shape[0])

    # if save_img:
    #     if dataset.mode == 'image':
    #         cv2.imwrite("output.jpg", im0)
    #     else:  # 'video' or 'stream'
    #         if vid_path[i] != save_path:  # new video
    #             vid_path[i] = save_path
    #             if isinstance(vid_writer[i], cv2.VideoWriter):
    #                 vid_writer[i].release()  # release previous video writer
    #             if vid_cap:  # video
    #                 fps = vid_cap.get(cv2.CAP_PROP_FPS)
    #                 w = int(vid_cap.get(cv2.CAP_PROP_FRAME_WIDTH))
    #                 h = int(vid_cap.get(cv2.CAP_PROP_FRAME_HEIGHT))
    #             else:  # stream
    #                 fps, w, h = 30, im0.shape[1], im0.shape[0]
    #             save_path = str(Path(save_path).with_suffix('.mp4'))  # force *.mp4 suffix on results videos
    #             vid_writer[i] = cv2.VideoWriter(save_path, cv2.VideoWriter_fourcc(*'mp4v'), fps, (w, h))
    #         vid_writer[i].write(im0)
# print("detection:" +str(len(det)))
# pipe_count=len(det)
# print("prediction is : ")
# print(det)
# LOGGER.info(f"{s}{'' if len(det) else '(no detections), '}{dt[1].dt * 1E3:.1f}ms")
# t = tuple(x.t / seen * 1E3 for x in dt)  # speeds per image
# LOGGER.info(f'Speed: %.1fms pre-process, %.1fms inference, %.1fms NMS per image at shape {(1, 3, *imgsz)}' % t)

# if save_txt or save_img:
#     s = f"\n{len(list(save_dir.glob('labels/*.txt')))} labels saved to {save_dir / 'labels'}" if save_txt else ''
#     LOGGER.info(f"Results saved to {colorstr('bold', save_dir)}{s}")
# return pipe_count
    return collect_data