# import the necessary packages
import cv2
import numpy as np


class GammaPreprocessor:
    def __init__(self, gamma=1.0):
        # creating Gamma table
        self.invGamma = 1.0 / gamma
        self.table = np.array([((i / 255.0) ** self.invGamma) * 255
                          for i in np.arange(0, 256)]).astype("uint8")

    def preprocess(self, image):
        return cv2.LUT(image, self.table)
