import configparser
import os

class EnvInterpolation(configparser.BasicInterpolation):
    """Interpolation which expands environment variables in values."""

    def before_get(self, parser, section, option, value, defaults):
        value = super().before_get(parser, section, option, value, defaults)

        if not os.path.expandvars(value).startswith("$"):
            return os.path.expandvars(value)
        else:
            return

config = configparser.ConfigParser(interpolation=EnvInterpolation())
CONFIGURATION_FILE = "conf/application.conf"
config.read(CONFIGURATION_FILE)


KEY_LOG = 'log'
KEY_DB = 'db'
KEY_SERVICE = 'service'
# Log section
LOG_FILE_NAME = config[KEY_LOG]["file_name"]
LOG_PATH = config[KEY_LOG]["path"]
LOG_LEVEL = config[KEY_LOG]["level"]
LOG_HANDLER = config[KEY_LOG]["handler"]
LOG_MAX_BYTES = int(config[KEY_LOG]["max_bytes"])
LOG_BACKUP_COUNT = int(config[KEY_LOG]["back_up_count"])

# DB

HOST = config[KEY_DB]["host"]
PORT = config[KEY_DB]["port"]
USER_NAME = config[KEY_DB]["user_name"]
PASSWORD = config[KEY_DB]["password"]
DB = config[KEY_DB]["db_name"]
TABLE = config[KEY_DB]["table_name"]

# Service
USERNAME = config.get(KEY_SERVICE, "user_name", fallback="None")