from fastapi import FastAPI
from scripts.constants.player_dicts import factory_map
from scripts.core.handlers.get_names import player_name

app = FastAPI()


@app.get("/details")
async def get_details(position: str, foot: str):
    factory_class = factory_map.get(foot)
    factory = factory_class()
    player = getattr(factory, f"create_{position}")()
    response = player_name(player)
    return response
